/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skRayFall.effectlib.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.rayfall.eyesniper2.skRayFall.effectlib.math.Transform;
import net.rayfall.eyesniper2.skRayFall.exp4j.Expression;
import net.rayfall.eyesniper2.skRayFall.exp4j.ExpressionBuilder;
import net.rayfall.eyesniper2.skRayFall.exp4j.function.Function;
import org.bukkit.configuration.ConfigurationSection;

public class EquationTransform
implements Transform {
    private Expression expression;
    private static Function randFunction;
    private static Function minFunction;
    private static Function maxFunction;
    private static Function selectFunction;
    private final Collection<String> inputVariables;
    private Exception exception;

    @Override
    public void load(ConfigurationSection parameters) {
        this.setEquation(parameters.getString("equation", ""));
    }

    public EquationTransform() {
        this.inputVariables = new ArrayList<String>();
    }

    public EquationTransform(String equation) {
        this(equation, "t");
    }

    public EquationTransform(String equation, String inputVariable) {
        this.inputVariables = new ArrayList<String>();
        this.inputVariables.add(inputVariable);
        this.setEquation(equation);
    }

    public EquationTransform(String equation, String ... inputVariables) {
        this.inputVariables = new ArrayList<String>();
        for (String inputVariable : inputVariables) {
            this.inputVariables.add(inputVariable);
        }
        this.setEquation(equation);
    }

    public EquationTransform(String equation, Collection<String> inputVariables) {
        this.inputVariables = inputVariables;
        this.setEquation(equation);
    }

    private void checkCustomFunctions() {
        if (randFunction == null) {
            randFunction = new Function("rand", 2){
                private Random random;
                {
                    this.random = new Random();
                }

                @Override
                public double apply(double ... args2) {
                    return this.random.nextDouble() * (args2[1] - args2[0]) + args2[0];
                }
            };
        }
        if (minFunction == null) {
            minFunction = new Function("min", 2){

                @Override
                public double apply(double ... args2) {
                    return Math.min(args2[0], args2[1]);
                }
            };
        }
        if (maxFunction == null) {
            maxFunction = new Function("max", 2){

                @Override
                public double apply(double ... args2) {
                    return Math.max(args2[0], args2[1]);
                }
            };
        }
        if (selectFunction == null) {
            selectFunction = new Function("select", 4){

                @Override
                public double apply(double ... args2) {
                    if (args2[0] < 0.0) {
                        return args2[1];
                    }
                    if (args2[0] == 0.0) {
                        return args2[2];
                    }
                    return args2[3];
                }
            };
        }
    }

    public boolean setEquation(String equation) {
        try {
            this.checkCustomFunctions();
            this.exception = null;
            this.expression = new ExpressionBuilder(equation).function(randFunction).function(minFunction).function(maxFunction).function(selectFunction).variables(new HashSet<String>(this.inputVariables)).build();
        }
        catch (Exception ex) {
            this.expression = null;
            this.exception = ex;
        }
        return this.exception == null;
    }

    @Override
    public double get(double t) {
        if (this.expression == null) {
            return 0.0;
        }
        for (String inputVariable : this.inputVariables) {
            this.expression.setVariable(inputVariable, t);
        }
        return this.get();
    }

    public double get(double ... t) {
        if (this.expression == null) {
            return 0.0;
        }
        int index = 0;
        for (String inputVariable : this.inputVariables) {
            this.expression.setVariable(inputVariable, t[index]);
            if (index >= t.length - 1) continue;
            ++index;
        }
        return this.get();
    }

    public void addVariable(String key) {
        this.inputVariables.add(key);
    }

    public void setVariable(String key, double value) {
        if (this.expression != null) {
            this.expression.setVariable(key, value);
        }
    }

    public double get() {
        if (this.expression == null) {
            return Double.NaN;
        }
        double value = Double.NaN;
        try {
            this.exception = null;
            value = this.expression.evaluate();
        }
        catch (Exception ex) {
            this.exception = ex;
        }
        return value;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isValid() {
        return this.exception == null;
    }

    public Collection<String> getParameters() {
        return this.inputVariables;
    }
}

