/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.effectlibsupport;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.VisualEffect;
import ch.njol.util.Kleenean;
import net.rayfall.eyesniper2.skRayFall.Metadata;
import net.rayfall.eyesniper2.skRayFall._Assertions;
import net.rayfall.eyesniper2.skRayFall.effectlib.effect.TornadoEffect;
import net.rayfall.eyesniper2.skRayFall.effectlib.util.DynamicLocation;
import net.rayfall.eyesniper2.skRayFall.jvm.internal.Intrinsics;
import net.rayfall.eyesniper2.skRayFall.text.StringsKt;
import net.rayfall.eyesniper2.skrayfall.Core;
import net.rayfall.eyesniper2.skrayfall.effectlibsupport.EffectLibUtils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Tornado Effect")
@Description(value={"Creates an EffectLib tornado effect."})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J9\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0012H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/rayfall/eyesniper2/skrayfall/effectlibsupport/EffEffectTornado;", "Lch/njol/skript/lang/Effect;", "()V", "cloudParticleExpression", "Lch/njol/skript/lang/Expression;", "Lch/njol/skript/util/VisualEffect;", "heightExpression", "", "idExpression", "", "radiusExpression", "targetExpression", "tornadoParticleExpression", "execute", "", "evt", "Lorg/bukkit/event/Event;", "init", "", "exp", "", "arg1", "", "arg2", "Lch/njol/util/Kleenean;", "arg3", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "toString", "skRayFall"})
public final class EffEffectTornado
extends Effect {
    @Nullable
    private Expression<?> targetExpression;
    @Nullable
    private Expression<String> idExpression;
    @Nullable
    private Expression<VisualEffect> tornadoParticleExpression;
    @Nullable
    private Expression<VisualEffect> cloudParticleExpression;
    @Nullable
    private Expression<Number> radiusExpression;
    @Nullable
    private Expression<Number> heightExpression;

    public boolean init(@NotNull Expression<?>[] exp, int arg1, @NotNull Kleenean arg2, @NotNull SkriptParser.ParseResult arg3) {
        Intrinsics.checkNotNullParameter(exp, "exp");
        Intrinsics.checkNotNullParameter(arg2, "arg2");
        Intrinsics.checkNotNullParameter(arg3, "arg3");
        this.targetExpression = exp[0];
        this.idExpression = exp[1];
        Expression<?> expression = exp[2];
        this.tornadoParticleExpression = expression instanceof Expression ? expression : null;
        expression = exp[3];
        this.cloudParticleExpression = expression instanceof Expression ? expression : null;
        this.radiusExpression = exp[4];
        this.heightExpression = exp[5];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event evt, boolean arg1) {
        return "";
    }

    protected void execute(@NotNull Event evt) {
        Intrinsics.checkNotNullParameter(evt, "evt");
        Expression<?> expression = this.targetExpression;
        Object target = expression != null ? expression.getSingle(evt) : null;
        Expression<String> expression2 = this.idExpression;
        String id = expression2 != null ? (String)expression2.getSingle(evt) : null;
        Expression<VisualEffect> expression3 = this.tornadoParticleExpression;
        Particle tornadoParticle = EffectLibUtils.getParticleFromVisualEffect(expression3 != null ? (VisualEffect)expression3.getSingle(evt) : null);
        Expression<VisualEffect> expression4 = this.cloudParticleExpression;
        Particle cloudParticle = EffectLibUtils.getParticleFromVisualEffect(expression4 != null ? (VisualEffect)expression4.getSingle(evt) : null);
        Expression<Number> expression5 = this.radiusExpression;
        Number radius = expression5 != null ? (Number)((Number)expression5.getSingle(evt)) : (Number)null;
        Expression<Number> expression6 = this.heightExpression;
        Number height = expression6 != null ? (Number)((Number)expression6.getSingle(evt)) : (Number)null;
        TornadoEffect baseEffect = new TornadoEffect(Core.effectManager);
        if (id == null) {
            Skript.warning((String)"Id was null for EffectLib Tornado");
            return;
        }
        Object object = target;
        if (object instanceof Entity) {
            baseEffect.setDynamicOrigin(new DynamicLocation((Entity)target));
        } else if (object instanceof Location) {
            baseEffect.setDynamicOrigin(new DynamicLocation((Location)target));
        } else if (_Assertions.ENABLED) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (tornadoParticle != null) {
            baseEffect.tornadoParticle = tornadoParticle;
        }
        if (cloudParticle != null) {
            baseEffect.cloudParticle = cloudParticle;
        }
        if (height != null) {
            baseEffect.tornadoHeight = height.floatValue();
        }
        if (radius != null) {
            baseEffect.maxTornadoRadius = radius.floatValue();
        }
        baseEffect.infinite();
        baseEffect.start();
        boolean setEffectSuccess = Core.rayfallEffectManager.setEffect(baseEffect, StringsKt.replace$default(id, "\"", "", false, 4, null));
        if (!setEffectSuccess) {
            baseEffect.cancel();
        }
    }
}

