/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.general.events;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="On Crafting Click")
@Description(value={"Called when:", "* 1st slot of player crafting inventory is clicked", "* 2nd slot of player crafting inventory is clicked", "* 3rd slot of player crafting inventory is clicked", "* 4th slot of player crafting inventory is clicked", "* Result slot of player crafting inventory is clicked", "This is called when a player clicks a slot in the players inventory crafting slot. 0 = Top left, 1 = Top Right, 2 = Bottom left, 3 = Bottom right, 4 = result slot"})
@Examples(value={"on crafting click in slot 1:", "\tmessage \"Click in slot 1\""})
public class EvtCraftClick
extends SkriptEvent {
    @Nullable
    private Literal<Number> evtslotclick;

    public boolean init(Literal<?>[] exprs, int arg1, SkriptParser.ParseResult arg2) {
        this.evtslotclick = exprs[0];
        return true;
    }

    public boolean check(Event evt) {
        InventoryClickEvent e = (InventoryClickEvent)evt;
        if (InventoryType.CRAFTING == e.getInventory().getType()) {
            if (e.getSlotType() != InventoryType.SlotType.QUICKBAR && e.getSlotType() != InventoryType.SlotType.CONTAINER) {
                if (this.evtslotclick == null) {
                    return true;
                }
                return e.getSlot() == ((Number)this.evtslotclick.getSingle()).intValue();
            }
            return false;
        }
        return false;
    }

    public String toString(Event event, boolean debug) {
        return "craft click in slot " + this.evtslotclick.toString(event, debug);
    }
}

