/*
 * Decompiled with CFR 0.152.
 */
package net.rayfall.eyesniper2.skrayfall.teams;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class TeamManager {
    private HashMap<String, Team> teamMap = new HashMap();
    private Scoreboard teamBoard;

    public TeamManager() {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        this.teamBoard = manager.getNewScoreboard();
    }

    public void createTeam(String teamName) {
        if (!this.teamMap.containsKey(teamName)) {
            Team team = this.teamBoard.registerNewTeam(teamName);
            this.teamMap.put(teamName, team);
            for (Object p : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Player tempPlayer = (Player)p;
                if (tempPlayer.getScoreboard().getTeams().contains(this.teamMap.get(teamName))) continue;
                Bukkit.broadcastMessage((String)"Team Reg!");
                tempPlayer.getScoreboard().registerNewTeam(teamName);
            }
        }
    }

    public void createTeam(String teamName, Player[] players) {
        if (!this.teamMap.containsKey(teamName)) {
            Team team = this.teamBoard.registerNewTeam(teamName);
            for (Player player : players) {
                team.addPlayer((OfflinePlayer)player);
            }
            this.teamMap.put(teamName, team);
            for (Object object : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Player tempPlayer = (Player)object;
                if (tempPlayer.getScoreboard().getTeams().contains(this.teamMap.get(teamName))) continue;
                Bukkit.broadcastMessage((String)"Team Reg!");
                Team newTeam = tempPlayer.getScoreboard().registerNewTeam(teamName);
                for (Player w : players) {
                    newTeam.addPlayer((OfflinePlayer)w);
                }
            }
        }
    }

    public boolean teamExists(String teamName) {
        return this.teamMap.containsKey(teamName);
    }

    public boolean isPlayerOnTeam(String teamName, Player player) {
        return this.teamMap.containsKey(teamName) && this.teamMap.get(teamName).getEntries().contains(player.getName());
    }

    public void addPlayesrToTeam(String teamName, Player[] players) {
        if (this.teamMap.containsKey(teamName)) {
            for (Player player : players) {
                this.teamMap.get(teamName).addEntry(player.getName());
            }
            for (Object e : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Player tempPlayer = (Player)e;
                Bukkit.broadcastMessage((String)"Player set!");
                for (Player player : players) {
                    tempPlayer.getScoreboard().getTeam(teamName).addEntry(player.getName());
                }
            }
        }
    }

    public void removePlayersFromTeam(String teamName, Player[] players) {
        if (this.teamMap.containsKey(teamName)) {
            for (Player player : players) {
                this.teamMap.get(teamName).removeEntry(player.getName());
            }
            for (Object object : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Bukkit.broadcastMessage((String)"Removed!");
                for (Player player : players) {
                    ((Player)object).getScoreboard().getTeam(teamName).removeEntry(player.getName());
                }
            }
        }
    }

    public void removeTeam(String teamName) {
        if (this.teamMap.containsKey(teamName)) {
            this.teamMap.remove(teamName);
            this.teamBoard.getTeam(teamName).unregister();
            for (Object e : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Player tempPlayer = (Player)e;
                if (tempPlayer.getScoreboard().getTeam(teamName) == null) continue;
                tempPlayer.getScoreboard().getTeam(teamName).unregister();
            }
        }
    }

    public void setPrefix(String team, String prefix) {
        if (this.teamMap.containsKey(team)) {
            this.teamMap.get(team).setPrefix(prefix);
            for (Object p : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Bukkit.broadcastMessage((String)"Prefix set!");
                ((Player)p).getScoreboard().getTeam(team).setPrefix(prefix);
            }
        }
    }

    public void setSuffix(String team, String suffix) {
        if (this.teamMap.containsKey(team)) {
            this.teamMap.get(team).setSuffix(suffix);
            for (Object p : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Bukkit.broadcastMessage((String)"Suffix set!");
                ((Player)p).getScoreboard().getTeam(team).setSuffix(suffix);
            }
        }
    }

    public void setFriendlyFire(String team, boolean result) {
        if (this.teamMap.containsKey(team)) {
            this.teamMap.get(team).setAllowFriendlyFire(result);
            for (Object p : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Bukkit.broadcastMessage((String)"Friendly fire set!");
                ((Player)p).getScoreboard().getTeam(team).setAllowFriendlyFire(result);
            }
        }
    }

    public void setFriendlyInvisibles(String team, boolean result) {
        if (this.teamMap.containsKey(team)) {
            this.teamMap.get(team).setAllowFriendlyFire(result);
            for (Object p : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Bukkit.broadcastMessage((String)"Friendly Invisibles set!");
                ((Player)p).getScoreboard().getTeam(team).setCanSeeFriendlyInvisibles(result);
            }
        }
    }

    public void setDisplayName(String team, String newTeamName) {
        if (this.teamMap.containsKey(team)) {
            this.teamMap.get(team).setDisplayName(newTeamName);
            for (Object p : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Bukkit.broadcastMessage((String)"Team display name set!");
                ((Player)p).getScoreboard().getTeam(team).setDisplayName(newTeamName);
            }
        }
    }

    public void setTeamNameTagVisibility(String team, NameTagVisibility vis) {
        if (this.teamMap.containsKey(team)) {
            this.teamMap.get(team).setNameTagVisibility(vis);
            for (Object p : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Bukkit.broadcastMessage((String)"Friendly Invisibles set!");
                ((Player)p).getScoreboard().getTeam(team).setNameTagVisibility(vis);
            }
        }
    }

    public void setTeamOption(String team, Team.Option option, Team.OptionStatus status) {
        if (this.teamMap.containsKey(team)) {
            this.teamMap.get(team).setOption(option, status);
            for (Object p : Bukkit.getServer().getOnlinePlayers().toArray()) {
                Bukkit.broadcastMessage((String)"Team option set!");
                ((Player)p).getScoreboard().getTeam(team).setOption(option, status);
            }
        }
    }
}

