/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.api.v1;

import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.HttpResponseException;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiContentProperty;
import io.javalin.openapi.OpenApiParam;
import io.javalin.openapi.OpenApiRequestBody;
import io.javalin.openapi.OpenApiResponse;
import io.servertap.api.v1.ValidationUtils;
import io.servertap.api.v1.models.Plugin;
import io.servertap.utils.pluginwrappers.EconomyWrapper;
import java.util.HashMap;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyApi {
    private final Server bukkitServer = Bukkit.getServer();
    private final EconomyWrapper economy;

    public EconomyApi(EconomyWrapper economyWrapper) {
        this.economy = economyWrapper;
    }

    @OpenApi(path="/v1/economy", methods={HttpMethod.GET}, summary="Economy plugin information", tags={"Economy"}, headers={@OpenApiParam(name="key")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="application/json")}), @OpenApiResponse(status="500", content={@OpenApiContent(type="application/json")})})
    public void getEconomyPluginInformation(Context ctx) {
        if (!this.economy.isAvailable()) {
            throw new HttpResponseException(424, "Vault not found or you are missing an economy plugin. Related functionality disabled", new HashMap<String, String>());
        }
        RegisteredServiceProvider rsp = this.bukkitServer.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            throw new InternalServerErrorResponse("Missing economy plugin");
        }
        org.bukkit.plugin.Plugin econPlugin = rsp.getPlugin();
        Plugin plugin = new Plugin();
        plugin.setName(econPlugin.getName());
        plugin.setEnabled(econPlugin.isEnabled());
        plugin.setVersion(econPlugin.getDescription().getVersion());
        ctx.json(plugin);
    }

    @OpenApi(path="/v1/economy/pay", methods={HttpMethod.POST}, summary="Pay a player", description="Deposits the provided amount into the player's Vault", tags={"Economy"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="uuid", type="string"), @OpenApiContentProperty(name="amount", type="double")})}), responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="application/json")}), @OpenApiResponse(status="500", content={@OpenApiContent(type="application/json")})})
    public void playerPay(Context ctx) {
        this.accountManager(ctx, TransactionType.PAY);
    }

    @OpenApi(path="/v1/economy/debit", methods={HttpMethod.POST}, summary="Debit a player", description="Withdraws the provided amount out of the player's Vault", tags={"Economy"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="uuid", type="string"), @OpenApiContentProperty(name="amount", type="double")})}), responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="application/json")}), @OpenApiResponse(status="500", content={@OpenApiContent(type="application/json")})})
    public void playerDebit(Context ctx) {
        this.accountManager(ctx, TransactionType.DEBIT);
    }

    private void accountManager(Context ctx, TransactionType action) {
        String uuid = ctx.formParam("uuid");
        String amount = ctx.formParam("amount");
        if (uuid == null || amount == null) {
            throw new BadRequestResponse("Missing uuid and/or amount");
        }
        if (!this.economy.isAvailable()) {
            throw new HttpResponseException(424, "Vault not found or you are missing an economy plugin. Related functionality disabled", new HashMap<String, String>());
        }
        UUID playerUUID = ValidationUtils.safeUUID(uuid);
        if (playerUUID == null) {
            throw new BadRequestResponse("Invalid UUID");
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUUID);
        double amountNum = Double.parseDouble(amount);
        if (amountNum <= 0.0) {
            throw new BadRequestResponse("You must use a value greater than zero");
        }
        EconomyResponse response = action == TransactionType.PAY ? this.economy.depositPlayer(player, amountNum) : this.economy.withdrawPlayer(player, amountNum);
        if (response.type != EconomyResponse.ResponseType.SUCCESS) {
            throw new InternalServerErrorResponse(response.errorMessage);
        }
        ctx.status(200).json("success");
    }

    private static enum TransactionType {
        PAY,
        DEBIT;

    }
}

