/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.api.v1;

import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiContentProperty;
import io.javalin.openapi.OpenApiParam;
import io.javalin.openapi.OpenApiRequestBody;
import io.javalin.openapi.OpenApiResponse;
import io.servertap.api.v1.ValidationUtils;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PAPIApi {
    @OpenApi(path="/v1/placeholders/replace", methods={HttpMethod.POST}, summary="Process a string using PlaceholderAPI", description="Process a string using PlaceholderAPI", tags={"PlaceholderAPI"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="message", type="string"), @OpenApiContentProperty(name="uuid", type="string")})}), responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="application/json")}), @OpenApiResponse(status="500", content={@OpenApiContent(type="application/json")})})
    public void replacePlaceholders(Context ctx) {
        String passedMessage;
        OfflinePlayer player = null;
        String passedUuid = ctx.formParam("uuid");
        if (passedUuid != null && !passedUuid.isEmpty()) {
            UUID playerUUID = ValidationUtils.safeUUID(passedUuid);
            if (playerUUID == null) {
                throw new BadRequestResponse("Invalid UUID");
            }
            player = Bukkit.getOfflinePlayer((UUID)playerUUID);
        }
        if ((passedMessage = ctx.formParam("message")) == null || passedMessage.isEmpty()) {
            throw new BadRequestResponse("Missing message from request");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            passedMessage = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)passedMessage);
        }
        ctx.status(200).json(passedMessage);
    }
}

