/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.api.v1;

import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.NotFoundResponse;
import io.javalin.http.ServiceUnavailableResponse;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiContentProperty;
import io.javalin.openapi.OpenApiParam;
import io.javalin.openapi.OpenApiRequestBody;
import io.javalin.openapi.OpenApiResponse;
import io.servertap.ServerTapMain;
import io.servertap.api.v1.ValidationUtils;
import io.servertap.api.v1.models.Objective;
import io.servertap.api.v1.models.OfflinePlayer;
import io.servertap.api.v1.models.Score;
import io.servertap.api.v1.models.Scoreboard;
import io.servertap.api.v1.models.Server;
import io.servertap.api.v1.models.ServerBan;
import io.servertap.api.v1.models.ServerHealth;
import io.servertap.api.v1.models.Whitelist;
import io.servertap.mojang.api.MojangApiService;
import io.servertap.utils.GsonSingleton;
import io.servertap.utils.LagDetector;
import io.servertap.utils.ServerExecCommandSender;
import io.servertap.utils.pluginwrappers.EconomyWrapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.ScoreboardManager;

public class ServerApi {
    private final Logger log;
    private final ServerTapMain main;
    private final EconomyWrapper economy;
    private final org.bukkit.Server bukkitServer = Bukkit.getServer();
    private final ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
    private final LagDetector lagDetector;

    public ServerApi(ServerTapMain main, Logger log, LagDetector lagDetector, EconomyWrapper economy) {
        this.log = log;
        this.main = main;
        this.economy = economy;
        this.lagDetector = lagDetector;
    }

    @OpenApi(path="/v1/ping", summary="pong!", tags={"Server"}, headers={@OpenApiParam(name="key")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="application/json")})})
    public void ping(Context ctx) {
        ctx.json("pong");
    }

    @OpenApi(path="/v1/server", summary="Get information about the server", tags={"Server"}, headers={@OpenApiParam(name="key")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=Server.class)})})
    public void serverGet(Context ctx) {
        Server server = new Server();
        server.setName(this.bukkitServer.getName());
        server.setMotd(this.bukkitServer.getMotd());
        server.setVersion(this.bukkitServer.getVersion());
        server.setBukkitVersion(this.bukkitServer.getBukkitVersion());
        server.setWhitelistedPlayers(this.getWhitelist());
        server.setMaxPlayers(this.bukkitServer.getMaxPlayers());
        server.setOnlinePlayers(this.bukkitServer.getOnlinePlayers().size());
        server.setTps(this.lagDetector.getTPSString());
        HashSet<ServerBan> bannedIps = new HashSet<ServerBan>();
        this.bukkitServer.getBanList(BanList.Type.IP).getBanEntries().forEach(banEntry -> {
            ServerBan ban = new ServerBan();
            ban.setSource(banEntry.getSource());
            ban.setExpiration(banEntry.getExpiration());
            ban.setReason(ban.getReason());
            ban.setTarget(banEntry.getTarget());
            bannedIps.add(ban);
        });
        server.setBannedIps(bannedIps);
        HashSet<ServerBan> bannedPlayers = new HashSet<ServerBan>();
        this.bukkitServer.getBanList(BanList.Type.NAME).getBanEntries().forEach(banEntry -> {
            ServerBan ban = new ServerBan();
            ban.setSource(banEntry.getSource());
            ban.setExpiration(banEntry.getExpiration());
            ban.setReason(ban.getReason());
            ban.setTarget(banEntry.getTarget());
            bannedPlayers.add(ban);
        });
        server.setBannedPlayers(bannedPlayers);
        ServerHealth health = new ServerHealth();
        int cpus = Runtime.getRuntime().availableProcessors();
        health.setCpus(cpus);
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime() / 1000L;
        health.setUptime(uptime);
        long memMax = Runtime.getRuntime().maxMemory();
        long memTotal = Runtime.getRuntime().totalMemory();
        long memFree = Runtime.getRuntime().freeMemory();
        health.setMaxMemory(memMax);
        health.setTotalMemory(memTotal);
        health.setFreeMemory(memFree);
        server.setHealth(health);
        ctx.json(server);
    }

    @OpenApi(path="/v1/chat/broadcast", methods={HttpMethod.POST}, summary="Send broadcast visible to those currently online.", tags={"Chat"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="message", type="string")})}), responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="application/json")})})
    public void broadcastPost(Context ctx) {
        String msg = ctx.formParam("message");
        if (msg != null && msg.isEmpty()) {
            throw new BadRequestResponse("Missing Message");
        }
        Bukkit.broadcastMessage((String)msg);
        ctx.json("success");
    }

    @OpenApi(path="/v1/chat/tell", methods={HttpMethod.POST}, summary="Send a message to a specific player.", tags={"Chat"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="message", type="string"), @OpenApiContentProperty(name="playerUuid", type="string")})}), responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="application/json")})})
    public void tellPost(Context ctx) {
        String msg = ctx.formParam("message");
        String uuid = ctx.formParam("playerUuid");
        if (msg != null && msg.isEmpty()) {
            throw new BadRequestResponse("Missing Message");
        }
        if (uuid != null && uuid.isEmpty()) {
            throw new BadRequestResponse("Player UUID is required");
        }
        UUID playerUUID = ValidationUtils.safeUUID(uuid);
        if (playerUUID == null) {
            throw new BadRequestResponse("Invalid UUID");
        }
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            throw new NotFoundResponse("Player cannot be found");
        }
        player.sendMessage(msg);
        ctx.json("success");
    }

    @OpenApi(path="/v1/scoreboard", summary="Get information about the scoreboard objectives", tags={"Server"}, headers={@OpenApiParam(name="key")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=Scoreboard.class)})})
    public void scoreboardGet(Context ctx) {
        org.bukkit.scoreboard.Scoreboard gameScoreboard = this.scoreboardManager.getMainScoreboard();
        Scoreboard scoreboardModel = new Scoreboard();
        HashSet<String> objectives = new HashSet<String>();
        HashSet<String> entries = new HashSet<String>(gameScoreboard.getEntries());
        gameScoreboard.getObjectives().forEach(objective -> objectives.add(objective.getName()));
        scoreboardModel.setEntries(entries);
        scoreboardModel.setObjectives(objectives);
        ctx.json(scoreboardModel);
    }

    @OpenApi(path="/v1/scoreboard/{name}", summary="Get information about a specific objective", tags={"Server"}, headers={@OpenApiParam(name="key")}, pathParams={@OpenApiParam(name="name", description="The name of the objective to get")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=Objective.class)})})
    public void objectiveGet(Context ctx) {
        String objectiveName = ctx.pathParam("name");
        org.bukkit.scoreboard.Scoreboard gameScoreboard = this.scoreboardManager.getMainScoreboard();
        org.bukkit.scoreboard.Objective objective = gameScoreboard.getObjective(objectiveName);
        if (objective == null) {
            throw new NotFoundResponse();
        }
        ctx.json(this.fromBukkitObjective(objective));
    }

    private Objective fromBukkitObjective(org.bukkit.scoreboard.Objective objective) {
        org.bukkit.scoreboard.Scoreboard gameScoreboard = this.scoreboardManager.getMainScoreboard();
        Objective o = new Objective();
        o.setCriterion(objective.getCriteria());
        o.setDisplayName(objective.getDisplayName());
        o.setName(objective.getName());
        o.setDisplaySlot("");
        if (objective.getDisplaySlot() != null) {
            o.setDisplaySlot(objective.getDisplaySlot().toString().toLowerCase());
        }
        HashSet<Score> scores = new HashSet<Score>();
        gameScoreboard.getEntries().forEach(entry -> {
            org.bukkit.scoreboard.Score score = objective.getScore(entry);
            if (score.isScoreSet()) {
                Score s = new Score();
                s.setEntry((String)entry);
                s.setValue(score.getScore());
                scores.add(s);
            }
        });
        o.setScores(scores);
        return o;
    }

    private Set<Whitelist> getWhitelist() {
        HashSet<Whitelist> whitelist = new HashSet<Whitelist>();
        this.bukkitServer.getWhitelistedPlayers().forEach(player -> whitelist.add(new Whitelist().offlinePlayer((org.bukkit.OfflinePlayer)player)));
        return whitelist;
    }

    @OpenApi(path="/v1/server/whitelist", methods={HttpMethod.GET}, summary="Get the whitelist", tags={"Server"}, headers={@OpenApiParam(name="key")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=Whitelist.class)})})
    public void whitelistGet(Context ctx) {
        if (this.bukkitServer.hasWhitelist()) {
            ctx.json("error: The server has whitelist disabled");
            return;
        }
        ctx.json(this.getWhitelist());
    }

    @OpenApi(path="/v1/server/whitelist", methods={HttpMethod.POST}, summary="Update the whitelist", description="Possible responses are: `success`, `failed`, `Error: duplicate entry`, and `No whitelist`.", tags={"Server"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="uuid", type="string"), @OpenApiContentProperty(name="name", type="string")})}), responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="application/json")})})
    public void whitelistPost(Context ctx) {
        if (!this.bukkitServer.hasWhitelist()) {
            ctx.json("No whitelist");
            return;
        }
        String uuid = ctx.formParam("uuid");
        String name = ctx.formParam("name");
        if (uuid == null && name == null) {
            throw new BadRequestResponse("Missing one of uuid or username");
        }
        if (uuid == null) {
            try {
                uuid = MojangApiService.getUuid(name);
            }
            catch (IllegalArgumentException ignored) {
                throw new NotFoundResponse("Player name doesn't exist");
            }
            catch (IOException ignored) {
                throw new ServiceUnavailableResponse("Failed to access Mojang API");
            }
        }
        uuid = uuid.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
        File directory = new File("./");
        Whitelist newEntry = new Whitelist().uuid(uuid).name(name);
        Set<Whitelist> whitelist = this.getWhitelist();
        for (Whitelist player : whitelist) {
            if (!player.equals(newEntry)) continue;
            ctx.json("Error: duplicate entry");
            return;
        }
        whitelist.add(newEntry);
        String json = GsonSingleton.getInstance().toJson(whitelist);
        try {
            String path = Paths.get(directory.getAbsolutePath(), "whitelist.json").toString();
            File myObj = new File(path);
            FileWriter whitelistFile = new FileWriter(myObj);
            whitelistFile.write(json);
            whitelistFile.close();
            this.bukkitServer.reloadWhitelist();
            ctx.json("success");
        }
        catch (IOException e) {
            this.log.warning("An error occurred updating whitelist.");
            e.printStackTrace();
            ctx.json("failed");
        }
    }

    @OpenApi(path="/v1/server/whitelist", methods={HttpMethod.DELETE}, summary="Delete specific player from the whitelist", tags={"Server"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="uuid", type="string"), @OpenApiContentProperty(name="name", type="string")})}), responses={@OpenApiResponse(status="200")})
    public void whitelistDelete(Context ctx) {
        if (!this.bukkitServer.hasWhitelist()) {
            ctx.json("No whitelist");
            return;
        }
        String uuid = ctx.formParam("uuid");
        String name = ctx.formParam("name");
        if (uuid == null && name == null) {
            throw new BadRequestResponse("Missing one of uuid or username");
        }
        if (uuid == null) {
            try {
                uuid = MojangApiService.getUuid(name);
            }
            catch (IllegalArgumentException ignored) {
                throw new NotFoundResponse("Player name doesn't exist");
            }
            catch (IOException ignored) {
                throw new ServiceUnavailableResponse("Failed to access Mojang API");
            }
        }
        uuid = uuid.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
        File directory = new File("./");
        Set<Whitelist> whitelist = this.getWhitelist();
        String finalUuid = uuid;
        whitelist.removeIf(entry -> entry.getUuid().toLowerCase().equals(finalUuid));
        String json = GsonSingleton.getInstance().toJson(whitelist);
        try {
            String path = Paths.get(directory.getAbsolutePath(), "whitelist.json").toString();
            File myObj = new File(path);
            FileWriter whitelistFile = new FileWriter(myObj);
            whitelistFile.write(json);
            whitelistFile.close();
            this.bukkitServer.reloadWhitelist();
            ctx.json("success");
        }
        catch (IOException e) {
            this.log.warning("An error occurred updating whitelist.");
            e.printStackTrace();
            ctx.json("failed");
        }
    }

    @OpenApi(path="/v1/server/ops", methods={HttpMethod.POST}, summary="Sets a specific player to Op", tags={"Player"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="playerUuid", type="string")})}), responses={@OpenApiResponse(status="200")})
    public void opPlayer(Context ctx) {
        String uuid = ctx.formParam("playerUuid");
        String name = ctx.formParam("name");
        if (name.isEmpty()) {
            throw new BadRequestResponse("Missing uuid and/or world");
        }
        UUID playerUUID = ValidationUtils.safeUUID(uuid);
        if (playerUUID == null) {
            throw new BadRequestResponse("Invalid UUID");
        }
        org.bukkit.OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUUID);
        if (player == null) {
            throw new NotFoundResponse("Player cannot be found");
        }
        player.setOp(true);
        ctx.json("success");
    }

    @OpenApi(path="/v1/server/ops", methods={HttpMethod.DELETE}, summary="Removes Op from a specific player", tags={"Player"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="playerUuid", type="string")})}), responses={@OpenApiResponse(status="200")})
    public void deopPlayer(Context ctx) {
        String uuid = ctx.formParam("playerUuid");
        if (uuid.isEmpty()) {
            throw new BadRequestResponse("Missing uuid and/or world");
        }
        UUID playerUUID = ValidationUtils.safeUUID(uuid);
        if (playerUUID == null) {
            throw new BadRequestResponse("Invalid UUID");
        }
        org.bukkit.OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUUID);
        if (player == null) {
            throw new NotFoundResponse("Player cannot be found");
        }
        player.setOp(false);
        ctx.json("success");
    }

    @OpenApi(path="/v1/server/ops", methods={HttpMethod.GET}, summary="Get all op players", tags={"Player"}, headers={@OpenApiParam(name="key")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=OfflinePlayer.class)})})
    public void getOps(Context ctx) {
        Set players = Bukkit.getOperators();
        ArrayList<OfflinePlayer> opedPlayers = new ArrayList<OfflinePlayer>();
        for (org.bukkit.OfflinePlayer player : players) {
            if (!player.isOp()) continue;
            OfflinePlayer p = new OfflinePlayer();
            p.setDisplayName(player.getName());
            p.setUuid(player.getUniqueId().toString());
            p.setWhitelisted(player.isWhitelisted());
            p.setBanned(player.isBanned());
            p.setOp(player.isOp());
            if (this.economy.isAvailable()) {
                p.setBalance(this.economy.getPlayerBalance(player));
            }
            opedPlayers.add(p);
        }
        ctx.json(opedPlayers);
    }

    @OpenApi(path="/v1/server/exec", methods={HttpMethod.POST}, summary="Executes a command on the server from the console, returning it's output. Be aware that not all command executors will properly send their messages to the CommandSender, though, most do.", tags={"Server"}, headers={@OpenApiParam(name="key")}, requestBody=@OpenApiRequestBody(required=true, content={@OpenApiContent(mimeType="application/x-www-form-urlencoded", properties={@OpenApiContentProperty(name="command", type="string"), @OpenApiContentProperty(name="time", type="long")})}), responses={@OpenApiResponse(status="200")})
    public void postCommand(Context ctx) {
        AtomicLong time;
        String command = ctx.formParam("command");
        String timeRaw = ctx.formParam("time");
        if (StringUtils.isBlank((String)command)) {
            throw new BadRequestResponse("Missing Command");
        }
        if (StringUtils.isBlank((String)timeRaw)) {
            timeRaw = "0";
        }
        if ((time = new AtomicLong(Long.parseLong(timeRaw))).get() < 0L) {
            time.set(0L);
        }
        ctx.future(() -> ((CompletableFuture)this.runCommandAsync(command, time.get()).thenAccept(ret -> {
            String output = String.join((CharSequence)"\n", ret);
            if ("application/json".equalsIgnoreCase(ctx.contentType())) {
                ctx.json(output);
            } else {
                ctx.html(output);
            }
        })).exceptionally(throwable -> {
            throw new RuntimeException((Throwable)throwable);
        }));
    }

    private CompletableFuture<List<String>> runCommandAsync(String command, long time) {
        return new ServerExecCommandSender(this.main).executeCommand(command, time, TimeUnit.MILLISECONDS);
    }
}

