/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.commands;

import io.servertap.ServerTapMain;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerTapCommand
implements CommandExecutor,
TabCompleter {
    private final ServerTapMain main;

    public ServerTapCommand(ServerTapMain main) {
        this.main = main;
        PluginCommand pluginCommand = main.getCommand("servertap");
        if (pluginCommand != null) {
            pluginCommand.setTabCompleter((TabCompleter)this);
            pluginCommand.setExecutor((CommandExecutor)this);
        }
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        if (!commandSender.hasPermission("servertap.admin")) {
            commandSender.sendMessage(String.format("%s[%sServerTap%s] %sYou do not have the permission to do that!", ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.DARK_GRAY, ChatColor.AQUA));
            return false;
        }
        if (args2.length == 1) {
            switch (args2[0]) {
                case "reload": {
                    this.main.reload();
                    commandSender.sendMessage(String.format("%s[%sServerTap%s] %sServerTap reloaded!", ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.DARK_GRAY, ChatColor.AQUA));
                    break;
                }
                case "info": {
                    String version = this.main.getDescription().getVersion();
                    String website = this.main.getDescription().getWebsite();
                    String authors = String.join((CharSequence)", ", this.main.getDescription().getAuthors());
                    commandSender.sendMessage(String.format("%sServerTap Plugin Information:\n%sVersion: %s%s\n%sWebsite: %s%s\n%sAuthors: %s%s", ChatColor.BLUE, ChatColor.BLUE, ChatColor.AQUA, version, ChatColor.BLUE, ChatColor.AQUA, website, ChatColor.BLUE, ChatColor.AQUA, authors));
                    break;
                }
                default: {
                    commandSender.sendMessage(String.format("%s[%sServerTap%s] %sUnknown Command.", ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.DARK_GRAY, ChatColor.AQUA));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String alias, @NotNull String[] args2) {
        if (!commandSender.hasPermission("servertap.admin")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args2.length == 0 || args2.length == 1 && args2[0].length() == 0) {
            completions.add("reload");
            completions.add("info");
        }
        return completions;
    }
}

