/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.mojang.api;

import com.google.gson.Gson;
import io.servertap.mojang.api.models.PlayerInfo;
import io.servertap.utils.GsonSingleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.stream.Collectors;

public class MojangApiService {
    private static final String getUuidResource = "https://api.mojang.com/users/profiles/minecraft/%s";

    public static String getUuid(String username) throws IOException {
        Gson gson = GsonSingleton.getInstance();
        ApiResponse apiResponse = MojangApiService.getApiResponse(String.format(getUuidResource, username));
        if (apiResponse.getHttpStatus() == 204) {
            throw new IllegalArgumentException("The given username was not found by the Mojang API.");
        }
        return gson.fromJson(apiResponse.getContent(), PlayerInfo.class).getId();
    }

    private static ApiResponse getApiResponse(String resource) throws IOException {
        try {
            String responseContent;
            URL url2 = new URL(resource);
            HttpURLConnection http = (HttpURLConnection)url2.openConnection();
            http.setRequestMethod("GET");
            http.setDoInput(true);
            http.connect();
            if (http.getResponseCode() == 400) {
                return new ApiResponse("", http.getResponseCode());
            }
            try (InputStream is = http.getInputStream();){
                responseContent = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
            }
            return new ApiResponse(responseContent, http.getResponseCode());
        }
        catch (MalformedURLException ignored) {
            throw new IllegalArgumentException("The given resource string is not a valid URL.");
        }
    }

    private static <T> ApiResponse getApiResponse(String resource, T requestData) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private static class ApiResponse {
        private String content;
        private int httpStatus;

        public ApiResponse(String content, int httpStatus) {
            this.setContent(content);
            this.setHttpStatus(httpStatus);
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public void setHttpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
        }
    }
}

