/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.utils;

import io.servertap.ServerTapMain;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerExecCommandSender
implements ConsoleCommandSender {
    private static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(1);
    private static final ConsoleCommandSender CONSOLE_COMMAND_SENDER = Bukkit.getConsoleSender();
    private final ServerTapMain main;
    private final List<String> messageBuffer = new ArrayList<String>();

    public ServerExecCommandSender(ServerTapMain main) {
        this.main = main;
    }

    public CompletableFuture<List<String>> executeCommand(String command, long messagingTime, TimeUnit messagingUnit) {
        Future commandFuture = Bukkit.getScheduler().callSyncMethod((Plugin)this.main, () -> Bukkit.dispatchCommand((CommandSender)this, (String)command));
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        EXECUTOR.schedule(() -> {
            try {
                commandFuture.get(5L, TimeUnit.SECONDS);
                future.complete(this.messageBuffer);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                future.completeExceptionally(new RuntimeException("An error occurred while executing command", e));
            }
        }, messagingTime, messagingUnit);
        return future;
    }

    public void sendMessage(@NotNull String message) {
        this.messageBuffer.add(this.main.getConfig().getBoolean("normalizeMessages") ? ChatColor.stripColor((String)message) : message);
    }

    public void sendMessage(String[] messages) {
        for (String msg : messages) {
            this.sendMessage(msg);
        }
    }

    public void sendMessage(@Nullable UUID uuid, @NotNull String s) {
        this.sendMessage(s);
    }

    public void sendMessage(@Nullable UUID uuid, @NotNull String[] strings) {
        this.sendMessage(strings);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return CONSOLE_COMMAND_SENDER.addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int arg1) {
        return CONSOLE_COMMAND_SENDER.addAttachment(plugin, arg1);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String arg1, boolean arg2) {
        return CONSOLE_COMMAND_SENDER.addAttachment(plugin, arg1, arg2);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String arg1, boolean arg2, int arg3) {
        return CONSOLE_COMMAND_SENDER.addAttachment(plugin, arg1, arg2, arg3);
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CONSOLE_COMMAND_SENDER.getEffectivePermissions();
    }

    public boolean hasPermission(String arg0) {
        return CONSOLE_COMMAND_SENDER.hasPermission(arg0);
    }

    public boolean hasPermission(Permission arg0) {
        return CONSOLE_COMMAND_SENDER.hasPermission(arg0);
    }

    public boolean isPermissionSet(String arg0) {
        return CONSOLE_COMMAND_SENDER.isPermissionSet(arg0);
    }

    public boolean isPermissionSet(Permission arg0) {
        return CONSOLE_COMMAND_SENDER.isPermissionSet(arg0);
    }

    public void recalculatePermissions() {
        CONSOLE_COMMAND_SENDER.recalculatePermissions();
    }

    public void removeAttachment(PermissionAttachment arg0) {
        CONSOLE_COMMAND_SENDER.removeAttachment(arg0);
    }

    public boolean isOp() {
        return CONSOLE_COMMAND_SENDER.isOp();
    }

    public void setOp(boolean arg0) {
        CONSOLE_COMMAND_SENDER.setOp(arg0);
    }

    public String getName() {
        return CONSOLE_COMMAND_SENDER.getName();
    }

    public Server getServer() {
        return CONSOLE_COMMAND_SENDER.getServer();
    }

    public boolean isConversing() {
        return CONSOLE_COMMAND_SENDER.isConversing();
    }

    public void acceptConversationInput(@NotNull String input) {
        CONSOLE_COMMAND_SENDER.acceptConversationInput(input);
    }

    public boolean beginConversation(@NotNull Conversation conversation) {
        return CONSOLE_COMMAND_SENDER.beginConversation(conversation);
    }

    public void abandonConversation(@NotNull Conversation conversation) {
        CONSOLE_COMMAND_SENDER.abandonConversation(conversation);
    }

    public void abandonConversation(@NotNull Conversation conversation, @NotNull ConversationAbandonedEvent details) {
        CONSOLE_COMMAND_SENDER.abandonConversation(conversation, details);
    }

    public void sendRawMessage(String raw) {
        CONSOLE_COMMAND_SENDER.sendRawMessage(raw);
    }

    public void sendRawMessage(@Nullable UUID uuid, @NotNull String raw) {
        CONSOLE_COMMAND_SENDER.sendRawMessage(uuid, raw);
    }

    public CommandSender.Spigot spigot() {
        try {
            return (CommandSender.Spigot)CommandSender.class.getMethod("spigot", new Class[0]).invoke((Object)CONSOLE_COMMAND_SENDER, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public Component name() {
        return CONSOLE_COMMAND_SENDER.name();
    }
}

