/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.utils.pluginwrappers;

import io.servertap.ServerTapMain;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyWrapper {
    private final ServerTapMain main;
    private final Logger log;
    private Economy economy;

    public EconomyWrapper(ServerTapMain main, Logger logger) {
        this.main = main;
        this.log = logger;
        this.setupEconomy();
    }

    public boolean isAvailable() {
        return this.economy != null;
    }

    public double getPlayerBalance(OfflinePlayer player) {
        return this.economy.getBalance(player);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        return this.economy.depositPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        return this.economy.withdrawPlayer(player, amount);
    }

    private void setupEconomy() {
        if (this.main.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.log.info("[ServerTap] No Vault plugin detected");
            return;
        }
        RegisteredServiceProvider rsp = this.main.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.log.info("[ServerTap] No Economy providers detected");
            return;
        }
        this.log.info(String.format("[ServerTap] Hooked economy provider: %s", ((Economy)rsp.getProvider()).getName()));
        this.economy = (Economy)rsp.getProvider();
    }
}

