/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.webhooks;

import com.google.gson.Gson;
import io.servertap.ServerTapMain;
import io.servertap.api.v1.models.Player;
import io.servertap.utils.GsonSingleton;
import io.servertap.utils.pluginwrappers.EconomyWrapper;
import io.servertap.webhooks.Webhook;
import io.servertap.webhooks.models.events.PlayerChatWebhookEvent;
import io.servertap.webhooks.models.events.PlayerDeathWebhookEvent;
import io.servertap.webhooks.models.events.PlayerJoinWebhookEvent;
import io.servertap.webhooks.models.events.PlayerKickWebhookEvent;
import io.servertap.webhooks.models.events.PlayerQuitWebhookEvent;
import io.servertap.webhooks.models.events.WebhookEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WebhookEventListener
implements Listener {
    private final Logger log;
    private final ServerTapMain main;
    private final EconomyWrapper economyWrapper;
    private List<Webhook> webhooks;

    public WebhookEventListener(ServerTapMain main, FileConfiguration bukkitConfig, Logger logger, EconomyWrapper economyWrapper) {
        this.main = main;
        this.log = logger;
        this.economyWrapper = economyWrapper;
        this.loadWebhooksFromConfig(bukkitConfig);
    }

    public void loadWebhooksFromConfig(FileConfiguration bukkitConfig) {
        this.webhooks = this.getWebhooksFromConfig(bukkitConfig);
    }

    private List<Webhook> getWebhooksFromConfig(FileConfiguration bukkitConfig) {
        ArrayList<Webhook> configWebhooks = new ArrayList<Webhook>();
        ConfigurationSection webhookSection = bukkitConfig.getConfigurationSection("webhooks");
        if (webhookSection == null) {
            return configWebhooks;
        }
        Set webhookNames = webhookSection.getKeys(false);
        for (String webhookName : webhookNames) {
            String configPath = "webhooks." + webhookName + ".";
            Webhook.getWebhookFromConfig(bukkitConfig, webhookName, configPath, this.log).ifPresent(configWebhooks::add);
        }
        return configWebhooks;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        PlayerChatWebhookEvent eventModel = new PlayerChatWebhookEvent();
        eventModel.setPlayer(this.fromBukkitPlayer(event.getPlayer()));
        eventModel.setMessage(this.normalizeMessage(event.getMessage()));
        eventModel.setPlayerName(event.getPlayer().getDisplayName());
        this.broadcastEvent(eventModel, WebhookEvent.EventType.PlayerChat);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        PlayerDeathWebhookEvent eventModel = new PlayerDeathWebhookEvent();
        Player player = this.fromBukkitPlayer(event.getEntity());
        ArrayList<io.servertap.api.v1.models.ItemStack> drops = new ArrayList<io.servertap.api.v1.models.ItemStack>();
        event.getDrops().forEach(itemStack -> drops.add(this.fromBukkitItemStack((ItemStack)itemStack)));
        eventModel.setPlayer(player);
        eventModel.setDrops(drops);
        eventModel.setDeathMessage(this.normalizeMessage(event.getDeathMessage()));
        this.broadcastEvent(eventModel, WebhookEvent.EventType.PlayerDeath);
    }

    private io.servertap.api.v1.models.ItemStack fromBukkitItemStack(ItemStack itemStack) {
        io.servertap.api.v1.models.ItemStack i = new io.servertap.api.v1.models.ItemStack();
        i.setId("minecraft:" + itemStack.getType().toString().toLowerCase());
        i.setCount(itemStack.getAmount());
        i.setSlot(-1);
        return i;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        PlayerJoinWebhookEvent eventModel = new PlayerJoinWebhookEvent();
        Player player = this.fromBukkitPlayer(event.getPlayer());
        eventModel.setPlayer(player);
        eventModel.setJoinMessage(this.normalizeMessage(event.getJoinMessage()));
        this.broadcastEvent(eventModel, WebhookEvent.EventType.PlayerJoin);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerQuitWebhookEvent eventModel = new PlayerQuitWebhookEvent();
        Player player = this.fromBukkitPlayer(event.getPlayer());
        eventModel.setPlayer(player);
        eventModel.setQuitMessage(this.normalizeMessage(event.getQuitMessage()));
        this.broadcastEvent(eventModel, WebhookEvent.EventType.PlayerQuit);
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        PlayerKickWebhookEvent eventModel = new PlayerKickWebhookEvent();
        Player player = this.fromBukkitPlayer(event.getPlayer());
        eventModel.setPlayer(player);
        eventModel.setReason(this.normalizeMessage(event.getReason()));
        this.broadcastEvent(eventModel, WebhookEvent.EventType.PlayerKick);
    }

    private void broadcastEvent(WebhookEvent eventModel, WebhookEvent.EventType eventType) {
        for (Webhook webhook : this.webhooks) {
            List<WebhookEvent.EventType> registeredEvents = webhook.getRegisteredEvents();
            if (!registeredEvents.contains((Object)eventType)) continue;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, () -> WebhookEventListener.sendHttpRequest(eventModel, webhook));
        }
    }

    private static void sendHttpRequest(WebhookEvent eventModel, Webhook webhook) {
        try {
            Gson gson = GsonSingleton.getInstance();
            String jsonContent = gson.toJson(eventModel);
            byte[] output = jsonContent.getBytes(StandardCharsets.UTF_8);
            URL url2 = new URL(webhook.getListenerUrl());
            HttpURLConnection http = (HttpURLConnection)url2.openConnection();
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            http.setFixedLengthStreamingMode(output.length);
            http.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            http.connect();
            try (OutputStream os = http.getOutputStream();){
                os.write(output);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Player fromBukkitPlayer(org.bukkit.entity.Player player) {
        Player p = new Player();
        if (this.economyWrapper.isAvailable()) {
            p.setBalance(this.economyWrapper.getPlayerBalance((OfflinePlayer)player));
        }
        p.setUuid(player.getUniqueId().toString());
        p.setDisplayName(player.getDisplayName());
        InetSocketAddress playerAddress = player.getAddress();
        if (playerAddress != null) {
            p.setAddress(playerAddress.getHostString());
            p.setPort(playerAddress.getPort());
        }
        p.setExhaustion(Float.valueOf(player.getExhaustion()));
        p.setExp(Float.valueOf(player.getExp()));
        p.setWhitelisted(player.isWhitelisted());
        p.setBanned(player.isBanned());
        p.setOp(player.isOp());
        return p;
    }

    private String normalizeMessage(String message) {
        try {
            if (!this.main.getConfig().getBoolean("normalizeMessages")) {
                return message;
            }
            return ChatColor.stripColor((String)message);
        }
        catch (Exception e) {
            return message;
        }
    }
}

