/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.translation.Translatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Difficulty implements Translatable
{
    PEACEFUL(0),
    EASY(1),
    NORMAL(2),
    HARD(3);

    private final int value;
    private static final Map<Integer, Difficulty> BY_ID;

    private Difficulty(int value) {
        this.value = value;
    }

    @Deprecated
    public int getValue() {
        return this.value;
    }

    @NotNull
    public String translationKey() {
        return "options.difficulty." + this.name().toLowerCase(Locale.ENGLISH);
    }

    @Deprecated
    @Nullable
    public static Difficulty getByValue(int value) {
        return BY_ID.get(value);
    }

    static {
        BY_ID = Maps.newHashMap();
        for (Difficulty diff : Difficulty.values()) {
            BY_ID.put(diff.value, diff);
        }
    }
}

