/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.jetbrains.annotations.NotNull;

public abstract class CookingRecipe<T extends CookingRecipe>
implements Recipe,
Keyed {
    private final NamespacedKey key;
    private ItemStack output;
    private RecipeChoice ingredient;
    private float experience;
    private int cookingTime;
    private String group = "";
    private CookingBookCategory category = CookingBookCategory.MISC;

    public CookingRecipe(@NotNull NamespacedKey key, @NotNull ItemStack result, @NotNull Material source, float experience, int cookingTime) {
        this(key, result, new RecipeChoice.MaterialChoice(Collections.singletonList(source)), experience, cookingTime);
    }

    public CookingRecipe(@NotNull NamespacedKey key, @NotNull ItemStack result, @NotNull RecipeChoice input, float experience, int cookingTime) {
        Preconditions.checkArgument((result.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Recipe must have non-AIR result.");
        this.key = key;
        this.output = new ItemStack(result);
        this.ingredient = input;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    @NotNull
    public CookingRecipe setInput(@NotNull Material input) {
        this.ingredient = new RecipeChoice.MaterialChoice(Collections.singletonList(input));
        return this;
    }

    @Deprecated
    @NotNull
    public ItemStack getInput() {
        return this.ingredient.getItemStack();
    }

    @NotNull
    public T setInputChoice(@NotNull RecipeChoice input) {
        this.ingredient = input;
        return (T)this;
    }

    @NotNull
    public RecipeChoice getInputChoice() {
        return this.ingredient.clone();
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.output.clone();
    }

    public void setExperience(float experience) {
        this.experience = experience;
    }

    public float getExperience() {
        return this.experience;
    }

    public void setCookingTime(int cookingTime) {
        Preconditions.checkArgument((cookingTime >= 0 ? 1 : 0) != 0, (Object)"cookingTime must be >= 0");
        this.cookingTime = cookingTime;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@NotNull String group) {
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"group cannot be null");
        this.group = group;
    }

    @NotNull
    public CookingBookCategory getCategory() {
        return this.category;
    }

    public void setCategory(@NotNull CookingBookCategory category) {
        Preconditions.checkArgument((category != null ? 1 : 0) != 0, (Object)"category cannot be null");
        this.category = category;
    }
}

