/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.events.bukkit.PreScriptLoadEvent;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.sections.SecLoop;
import ch.njol.skript.structures.StructOptions;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.TypeHints;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.OpenCloseable;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.structure.Structure;

public class ScriptLoader {
    public static final String DISABLED_SCRIPT_PREFIX = "-";
    public static final int DISABLED_SCRIPT_PREFIX_LENGTH = "-".length();
    private static final Set<Script> loadedScripts = Collections.synchronizedSortedSet(new TreeSet<Script>(new Comparator<Script>(){

        @Override
        public int compare(Script s1, Script s2) {
            File f2Parent;
            File f1 = s1.getConfig().getFile();
            File f2 = s2.getConfig().getFile();
            if (f1 == null || f2 == null) {
                throw new IllegalArgumentException("Scripts will null config files cannot be sorted.");
            }
            File f1Parent = f1.getParentFile();
            if (this.isSubDir(f1Parent, f2Parent = f2.getParentFile())) {
                return -1;
            }
            if (this.isSubDir(f2Parent, f1Parent)) {
                return 1;
            }
            return f1.compareTo(f2);
        }

        private boolean isSubDir(File directory, File subDir) {
            for (File parentDir = directory.getParentFile(); parentDir != null; parentDir = parentDir.getParentFile()) {
                if (!subDir.equals(parentDir)) continue;
                return true;
            }
            return false;
        }
    }));
    private static final FileFilter loadedScriptFilter = f -> f != null && (f.isDirectory() && !f.getName().startsWith(".") || !f.isDirectory() && StringUtils.endsWithIgnoreCase(f.getName(), ".sk")) && !f.getName().startsWith(DISABLED_SCRIPT_PREFIX) && !f.isHidden();
    private static final Set<File> disabledScripts = Collections.synchronizedSet(new HashSet());
    private static final FileFilter disabledScriptFilter = f -> f != null && (f.isDirectory() && !f.getName().startsWith(".") || !f.isDirectory() && StringUtils.endsWithIgnoreCase(f.getName(), ".sk")) && f.getName().startsWith(DISABLED_SCRIPT_PREFIX) && !f.isHidden();
    private static final BlockingQueue<Runnable> loadQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadGroup asyncLoaderThreadGroup = new ThreadGroup("Skript async loaders");
    private static final List<AsyncLoaderThread> loaderThreads = new ArrayList<AsyncLoaderThread>();
    private static int asyncLoaderSize;

    private static ParserInstance getParser() {
        return ParserInstance.get();
    }

    public static @Nullable Script getScript(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Something other than a file was provided.");
        }
        for (Script script : loadedScripts) {
            if (!file.equals(script.getConfig().getFile())) continue;
            return script;
        }
        return null;
    }

    public static Set<Script> getScripts(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Something other than a directory was provided.");
        }
        HashSet<Script> scripts = new HashSet<Script>();
        for (File file : directory.listFiles(loadedScriptFilter)) {
            if (file.isDirectory()) {
                scripts.addAll(ScriptLoader.getScripts(file));
                continue;
            }
            Script script = ScriptLoader.getScript(file);
            if (script == null) continue;
            scripts.add(script);
        }
        return scripts;
    }

    static void updateDisabledScripts(Path path) {
        disabledScripts.clear();
        try (Stream<Path> files = Files.walk(path, new FileVisitOption[0]);){
            files.map(Path::toFile).filter(disabledScriptFilter::accept).forEach(disabledScripts::add);
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "An error occurred while trying to update the list of disabled scripts!");
        }
    }

    public static boolean isAsync() {
        return asyncLoaderSize > 0;
    }

    public static boolean isParallel() {
        return asyncLoaderSize > 1;
    }

    public static void setAsyncLoaderSize(int size) throws IllegalStateException {
        asyncLoaderSize = size;
        if (size <= 0) {
            for (AsyncLoaderThread thread : loaderThreads) {
                thread.cancelExecution();
            }
            return;
        }
        while (loaderThreads.size() > size) {
            AsyncLoaderThread thread = loaderThreads.remove(loaderThreads.size() - 1);
            thread.cancelExecution();
        }
        while (loaderThreads.size() < size) {
            loaderThreads.add(AsyncLoaderThread.create());
        }
        if (loaderThreads.size() != size) {
            throw new IllegalStateException();
        }
    }

    private static <T> CompletableFuture<T> makeFuture(Supplier<T> supplier, OpenCloseable openCloseable) {
        CompletableFuture future = new CompletableFuture();
        Runnable task = () -> {
            try {
                Object t;
                openCloseable.open();
                try {
                    t = supplier.get();
                }
                finally {
                    openCloseable.close();
                }
                future.complete(t);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
                Skript.exception(t, new String[0]);
            }
        };
        if (ScriptLoader.isAsync() && Bukkit.isPrimaryThread()) {
            loadQueue.add(task);
        } else {
            task.run();
            assert (future.isDone());
        }
        return future;
    }

    public static CompletableFuture<ScriptInfo> loadScripts(File file, OpenCloseable openCloseable) {
        return ScriptLoader.loadScripts(ScriptLoader.loadStructures(file), openCloseable);
    }

    public static CompletableFuture<ScriptInfo> loadScripts(Set<File> files, OpenCloseable openCloseable) {
        return ScriptLoader.loadScripts(files.stream().sorted().map(ScriptLoader::loadStructures).flatMap(Collection::stream).collect(Collectors.toList()), openCloseable);
    }

    private static CompletableFuture<ScriptInfo> loadScripts(List<Config> configs, OpenCloseable openCloseable) {
        if (configs.isEmpty()) {
            return CompletableFuture.completedFuture(new ScriptInfo());
        }
        Bukkit.getPluginManager().callEvent((Event)new PreScriptLoadEvent(configs));
        ScriptInfo scriptInfo = new ScriptInfo();
        ArrayList scripts = new ArrayList();
        ArrayList<CompletableFuture<Void>> scriptInfoFutures = new ArrayList<CompletableFuture<Void>>();
        for (Config config : configs) {
            if (config == null) {
                throw new NullPointerException();
            }
            CompletableFuture<Void> future = ScriptLoader.makeFuture(() -> {
                NonNullPair<Script, List<Structure>> pair = ScriptLoader.loadScript(config);
                scripts.add(pair);
                scriptInfo.add(new ScriptInfo(1, pair.getSecond().size()));
                return null;
            }, openCloseable);
            scriptInfoFutures.add(future);
        }
        return CompletableFuture.allOf(scriptInfoFutures.toArray(new CompletableFuture[0])).thenApply(unused -> {
            ParserInstance parser = ScriptLoader.getParser();
            try {
                openCloseable.open();
                List pairs = scripts.stream().flatMap(pair -> ((List)pair.getSecond()).stream().map(structure -> new NonNullPair<NonNullPair, Structure>((NonNullPair)pair, (Structure)structure))).sorted(Comparator.comparing(pair -> ((Structure)pair.getSecond()).getPriority())).collect(Collectors.toCollection(ArrayList::new));
                pairs.removeIf(pair -> {
                    Structure structure = (Structure)pair.getSecond();
                    parser.setActive((Script)((NonNullPair)pair.getFirst()).getFirst());
                    parser.setCurrentStructure(structure);
                    parser.setNode(structure.getEntryContainer().getSource());
                    try {
                        if (!structure.preLoad()) {
                            ((List)((NonNullPair)pair.getFirst()).getSecond()).remove(structure);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Skript.exception((Throwable)e, "An error occurred while trying to preLoad a Structure.");
                        ((List)((NonNullPair)pair.getFirst()).getSecond()).remove(structure);
                        return true;
                    }
                    return false;
                });
                parser.setInactive();
                pairs.removeIf(pair -> {
                    Structure structure = (Structure)pair.getSecond();
                    parser.setActive((Script)((NonNullPair)pair.getFirst()).getFirst());
                    parser.setCurrentStructure(structure);
                    parser.setNode(structure.getEntryContainer().getSource());
                    try {
                        if (!structure.load()) {
                            ((List)((NonNullPair)pair.getFirst()).getSecond()).remove(structure);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Skript.exception((Throwable)e, "An error occurred while trying to load a Structure.");
                        ((List)((NonNullPair)pair.getFirst()).getSecond()).remove(structure);
                        return true;
                    }
                    return false;
                });
                parser.setInactive();
                pairs.removeIf(pair -> {
                    Structure structure = (Structure)pair.getSecond();
                    parser.setActive((Script)((NonNullPair)pair.getFirst()).getFirst());
                    parser.setCurrentStructure(structure);
                    parser.setNode(structure.getEntryContainer().getSource());
                    try {
                        if (!structure.postLoad()) {
                            ((List)((NonNullPair)pair.getFirst()).getSecond()).remove(structure);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Skript.exception((Throwable)e, "An error occurred while trying to postLoad a Structure.");
                        ((List)((NonNullPair)pair.getFirst()).getSecond()).remove(structure);
                        return true;
                    }
                    return false;
                });
                parser.setInactive();
                ScriptInfo scriptInfo2 = scriptInfo;
                return scriptInfo2;
            }
            catch (Exception e) {
                throw Skript.exception((Throwable)e, new String[0]);
            }
            finally {
                parser.setInactive();
                openCloseable.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NonNullPair<Script, List<Structure>> loadScript(Config config) {
        if (config.getFile() == null) {
            throw new IllegalArgumentException("A config must have a file to be loaded.");
        }
        ParserInstance parser = ScriptLoader.getParser();
        ArrayList<Structure> structures = new ArrayList<Structure>();
        Script script = new Script(config, structures);
        parser.setActive(script);
        try {
            if (SkriptConfig.keepConfigsLoaded.value().booleanValue()) {
                SkriptConfig.configs.add(config);
            }
            try (CountingLogHandler ignored = new CountingLogHandler(SkriptLogger.SEVERE).start();){
                for (Node cnode : config.getMainNode()) {
                    Structure structure;
                    if (!(cnode instanceof SectionNode)) {
                        Skript.error("invalid line - all code has to be put into triggers");
                        continue;
                    }
                    SectionNode node = (SectionNode)cnode;
                    String line = node.getKey();
                    if (line == null || !SkriptParser.validateLine(line)) continue;
                    if (Skript.logVeryHigh() && !Skript.debug()) {
                        Skript.info("loading trigger '" + line + "'");
                    }
                    if ((structure = Structure.parse(line = ScriptLoader.replaceOptions(line), node, "Can't understand this structure: " + line)) == null) continue;
                    structures.add(structure);
                }
                if (Skript.logHigh()) {
                    int count = structures.size();
                    Skript.info("loaded " + count + " structure" + (count == 1 ? "" : "s") + " from '" + config.getFileName() + "'");
                }
            }
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Could not load " + config.getFileName());
        }
        finally {
            parser.setInactive();
        }
        Callable<Void> callable = () -> {
            File file = config.getFile();
            assert (file != null);
            File disabledFile = new File(file.getParentFile(), DISABLED_SCRIPT_PREFIX + file.getName());
            disabledScripts.remove(disabledFile);
            loadedScripts.add(script);
            return null;
        };
        if (ScriptLoader.isAsync()) {
            Task.callSync(callable);
        } else {
            try {
                callable.call();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
        return new NonNullPair<Script, List<Structure>>(script, structures);
    }

    private static List<Config> loadStructures(File directory) {
        if (!directory.isDirectory()) {
            Config config = ScriptLoader.loadStructure(directory);
            return config != null ? Collections.singletonList(config) : Collections.emptyList();
        }
        try {
            directory = directory.getCanonicalFile();
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, "An exception occurred while trying to get the canonical file of: " + directory);
            return new ArrayList<Config>();
        }
        Object[] files = directory.listFiles(loadedScriptFilter);
        assert (files != null);
        Arrays.sort(files);
        ArrayList<Config> loadedDirectories = new ArrayList<Config>(files.length);
        ArrayList<Config> loadedFiles = new ArrayList<Config>(files.length);
        for (Object file : files) {
            if (((File)file).isDirectory()) {
                loadedDirectories.addAll(ScriptLoader.loadStructures((File)file));
                continue;
            }
            Config cfg = ScriptLoader.loadStructure((File)file);
            if (cfg == null) continue;
            loadedFiles.add(cfg);
        }
        loadedDirectories.addAll(loadedFiles);
        return loadedDirectories;
    }

    private static @Nullable Config loadStructure(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, "An exception occurred while trying to get the canonical file of: " + file);
            return null;
        }
        if (!file.exists()) {
            Script script = ScriptLoader.getScript(file);
            if (script != null) {
                ScriptLoader.unloadScript(script);
            }
            return null;
        }
        try {
            String name = Skript.getInstance().getDataFolder().toPath().toAbsolutePath().resolve("scripts").relativize(file.toPath().toAbsolutePath()).toString();
            return ScriptLoader.loadStructure(Files.newInputStream(file.toPath(), new OpenOption[0]), name);
        }
        catch (IOException e) {
            Skript.error("Could not load " + file.getName() + ": " + ExceptionUtils.toString(e));
            return null;
        }
    }

    private static @Nullable Config loadStructure(InputStream source, String name) {
        try {
            return new Config(source, name, Skript.getInstance().getDataFolder().toPath().resolve("scripts").resolve(name).toFile().getCanonicalFile(), true, false, ":");
        }
        catch (IOException e) {
            Skript.error("Could not load " + name + ": " + ExceptionUtils.toString(e));
            return null;
        }
    }

    public static ScriptInfo unloadScripts(Set<Script> scripts) {
        for (Script script : scripts) {
            if (!loadedScripts.contains(script)) {
                throw new SkriptAPIException("The script at '" + script.getConfig().getPath() + "' is not loaded!");
            }
            if (script.getConfig().getFile() != null) continue;
            throw new IllegalArgumentException("A script must have a file to be unloaded.");
        }
        ParserInstance parser = ScriptLoader.getParser();
        for (Script script : scripts) {
            parser.setActive(script);
            for (Structure structure : script.getStructures()) {
                structure.unload();
            }
        }
        parser.setInactive();
        ScriptInfo scriptInfo = new ScriptInfo();
        for (Script script : scripts) {
            List<Structure> structures = script.getStructures();
            ++scriptInfo.files;
            scriptInfo.structures += structures.size();
            parser.setActive(script);
            for (Structure structure : structures) {
                structure.postUnload();
            }
            parser.setInactive();
            script.clearData();
            loadedScripts.remove(script);
            File scriptFile = script.getConfig().getFile();
            assert (scriptFile != null);
            disabledScripts.add(new File(scriptFile.getParentFile(), DISABLED_SCRIPT_PREFIX + scriptFile.getName()));
        }
        return scriptInfo;
    }

    public static ScriptInfo unloadScript(Script script) {
        return ScriptLoader.unloadScripts(Collections.singleton(script));
    }

    public static CompletableFuture<ScriptInfo> reloadScript(Script script, OpenCloseable openCloseable) {
        return ScriptLoader.reloadScripts(Collections.singleton(script), openCloseable);
    }

    public static CompletableFuture<ScriptInfo> reloadScripts(Set<Script> scripts, OpenCloseable openCloseable) {
        ScriptLoader.unloadScripts(scripts);
        ArrayList<Config> configs = new ArrayList<Config>();
        for (Script script : scripts) {
            Config config = ScriptLoader.loadStructure(script.getConfig().getFile());
            if (config == null) {
                return CompletableFuture.completedFuture(new ScriptInfo());
            }
            configs.add(config);
        }
        return ScriptLoader.loadScripts(configs, openCloseable);
    }

    public static String replaceOptions(String string) {
        ParserInstance parser = ScriptLoader.getParser();
        if (!parser.isActive()) {
            return string;
        }
        StructOptions.OptionsData optionsData = parser.getCurrentScript().getData(StructOptions.OptionsData.class);
        if (optionsData == null) {
            return string;
        }
        return optionsData.replaceOptions(string);
    }

    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        ParserInstance parser = ScriptLoader.getParser();
        if (Skript.debug()) {
            parser.setIndentation(parser.getIndentation() + "    ");
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        for (Node subNode : node) {
            parser.setNode(subNode);
            String subNodeKey = subNode.getKey();
            if (subNodeKey == null) {
                throw new IllegalArgumentException("Encountered node with null key: '" + subNode + "'");
            }
            String expr = ScriptLoader.replaceOptions(subNodeKey);
            if (!SkriptParser.validateLine(expr)) continue;
            if (subNode instanceof SimpleNode) {
                long timeTaken;
                long start = System.currentTimeMillis();
                Statement stmt = Statement.parse(expr, "Can't understand this condition/effect: " + expr);
                if (stmt == null) continue;
                long requiredTime = SkriptConfig.longParseTimeWarningThreshold.value().getMilliSeconds();
                if (requiredTime > 0L && (timeTaken = System.currentTimeMillis() - start) > requiredTime) {
                    Skript.warning("The current line took a long time to parse (" + new Timespan(timeTaken) + "). Avoid using long lines and use parentheses to create clearer instructions.");
                }
                if (Skript.debug() || subNode.debug()) {
                    Skript.debug(SkriptColor.replaceColorChar(parser.getIndentation() + stmt.toString(null, true)));
                }
                items.add(stmt);
                continue;
            }
            if (!(subNode instanceof SectionNode)) continue;
            TypeHints.enterScope();
            Section section = Section.parse(expr, "Can't understand this section: " + expr, (SectionNode)subNode, items);
            if (section == null) continue;
            if (Skript.debug() || subNode.debug()) {
                Skript.debug(SkriptColor.replaceColorChar(parser.getIndentation() + section.toString(null, true)));
            }
            items.add(section);
            TypeHints.exitScope();
        }
        for (int i = 0; i < items.size() - 1; ++i) {
            ((TriggerItem)items.get(i)).setNext(items.get(i + 1));
        }
        parser.setNode(node);
        if (Skript.debug()) {
            parser.setIndentation(parser.getIndentation().substring(0, parser.getIndentation().length() - 4));
        }
        return items;
    }

    public static Set<Script> getLoadedScripts() {
        return Collections.unmodifiableSet(new HashSet<Script>(loadedScripts));
    }

    public static Set<File> getDisabledScripts() {
        return Collections.unmodifiableSet(new HashSet<File>(disabledScripts));
    }

    public static FileFilter getLoadedScriptsFilter() {
        return loadedScriptFilter;
    }

    public static FileFilter getDisabledScriptsFilter() {
        return disabledScriptFilter;
    }

    @Deprecated
    public static ScriptInfo unloadScript(File scriptFile) {
        Script script = ScriptLoader.getScript(scriptFile);
        if (script != null) {
            return ScriptLoader.unloadScript(script);
        }
        return new ScriptInfo();
    }

    @Deprecated
    private static ScriptInfo unloadScripts(File folder) {
        return ScriptLoader.unloadScripts(ScriptLoader.getScripts(folder));
    }

    @Deprecated
    public static CompletableFuture<ScriptInfo> reloadScript(File scriptFile, OpenCloseable openCloseable) {
        ScriptLoader.unloadScript(scriptFile);
        return ScriptLoader.loadScripts(scriptFile, openCloseable);
    }

    @Deprecated
    public static CompletableFuture<ScriptInfo> reloadScripts(File folder, OpenCloseable openCloseable) {
        ScriptLoader.unloadScripts(folder);
        return ScriptLoader.loadScripts(folder, openCloseable);
    }

    @Deprecated
    public static int loadedScripts() {
        return ScriptLoader.getLoadedScripts().size();
    }

    @Deprecated
    public static int loadedTriggers() {
        int loaded = 0;
        for (Script script : ScriptLoader.getLoadedScripts()) {
            loaded += script.getStructures().size();
        }
        return loaded;
    }

    @Deprecated
    static void loadScripts() {
        ScriptLoader.unloadScripts(ScriptLoader.getLoadedScripts());
        ScriptLoader.loadScripts(Skript.getInstance().getScriptsFolder(), OpenCloseable.EMPTY).join();
    }

    @Deprecated
    public static ScriptInfo loadScripts(List<Config> configs) {
        return ScriptLoader.loadScripts(configs, OpenCloseable.EMPTY).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static ScriptInfo loadScripts(List<Config> configs, List<LogEntry> logOut) {
        RetainingLogHandler logHandler = new RetainingLogHandler();
        try {
            ScriptInfo scriptInfo = ScriptLoader.loadScripts(configs, (OpenCloseable)logHandler).join();
            return scriptInfo;
        }
        finally {
            logOut.addAll(logHandler.getLog());
        }
    }

    @Deprecated
    public static ScriptInfo loadScripts(Config ... configs) {
        return ScriptLoader.loadScripts(Arrays.asList(configs), OpenCloseable.EMPTY).join();
    }

    @Deprecated
    public static ScriptInfo reloadScript(File script) {
        return ScriptLoader.reloadScript(script, OpenCloseable.EMPTY).join();
    }

    @Deprecated
    public static ScriptInfo reloadScripts(File folder) {
        return ScriptLoader.reloadScripts(folder, OpenCloseable.EMPTY).join();
    }

    @Deprecated
    public static Kleenean getHasDelayBefore() {
        return ScriptLoader.getParser().getHasDelayBefore();
    }

    @Deprecated
    public static void setHasDelayBefore(Kleenean hasDelayBefore) {
        ScriptLoader.getParser().setHasDelayBefore(hasDelayBefore);
    }

    @Deprecated
    public static @Nullable Config getCurrentScript() {
        ParserInstance parser = ScriptLoader.getParser();
        return parser.isActive() ? parser.getCurrentScript().getConfig() : null;
    }

    @Deprecated
    public static void setCurrentScript(@Nullable Config currentScript) {
        ScriptLoader.getParser().setCurrentScript(currentScript);
    }

    @Deprecated
    public static List<TriggerSection> getCurrentSections() {
        return ScriptLoader.getParser().getCurrentSections();
    }

    @Deprecated
    public static void setCurrentSections(List<TriggerSection> currentSections) {
        ScriptLoader.getParser().setCurrentSections(currentSections);
    }

    @Deprecated
    public static List<SecLoop> getCurrentLoops() {
        return ScriptLoader.getParser().getCurrentSections(SecLoop.class);
    }

    @Deprecated
    public static void setCurrentLoops(List<SecLoop> currentLoops) {
    }

    @Deprecated
    public static @Nullable String getCurrentEventName() {
        return ScriptLoader.getParser().getCurrentEventName();
    }

    @SafeVarargs
    @Deprecated
    public static void setCurrentEvent(String name, Class<? extends Event> ... events) {
        ScriptLoader.getParser().setCurrentEvent(name, events);
    }

    @Deprecated
    public static void deleteCurrentEvent() {
        ScriptLoader.getParser().deleteCurrentEvent();
    }

    @Deprecated
    public static boolean isCurrentEvent(@Nullable Class<? extends Event> event) {
        return ScriptLoader.getParser().isCurrentEvent(event);
    }

    @SafeVarargs
    @Deprecated
    public static boolean isCurrentEvent(Class<? extends Event> ... events) {
        return ScriptLoader.getParser().isCurrentEvent(events);
    }

    @Deprecated
    public static @Nullable Class<? extends Event>[] getCurrentEvents() {
        return ScriptLoader.getParser().getCurrentEvents();
    }

    @Deprecated
    public static Config loadStructure(Config config) {
        return config;
    }

    private static class AsyncLoaderThread
    extends Thread {
        private boolean shouldRun = true;

        public static AsyncLoaderThread create() {
            AsyncLoaderThread thread = new AsyncLoaderThread();
            thread.start();
            return thread;
        }

        private AsyncLoaderThread() {
            super(asyncLoaderThreadGroup, (Runnable)null);
        }

        @Override
        public void run() {
            while (this.shouldRun) {
                try {
                    Runnable runnable = (Runnable)loadQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (runnable == null) continue;
                    runnable.run();
                }
                catch (InterruptedException e) {
                    Skript.exception((Throwable)e, new String[0]);
                }
            }
        }

        public void cancelExecution() {
            this.shouldRun = false;
        }
    }

    public static class ScriptInfo {
        public int files;
        public int structures;

        public ScriptInfo() {
        }

        public ScriptInfo(int numFiles, int numStructures) {
            this.files = numFiles;
            this.structures = numStructures;
        }

        public ScriptInfo(ScriptInfo other) {
            this.files = other.files;
            this.structures = other.structures;
        }

        public void add(ScriptInfo other) {
            this.files += other.files;
            this.structures += other.structures;
        }

        public void subtract(ScriptInfo other) {
            this.files -= other.files;
            this.structures -= other.structures;
        }

        public String toString() {
            return "ScriptInfo{files=" + this.files + ",structures=" + this.structures + "}";
        }
    }
}

