/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Cloner;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.SerializableChanger;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.localization.Noun;
import ch.njol.util.coll.iterator.ArrayIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.arithmetic.Arithmetics;
import org.skriptlang.skript.lang.arithmetic.Operator;

@SuppressFBWarnings(value={"DM_STRING_VOID_CTOR"})
public class ClassInfo<T>
implements Debuggable {
    private final Class<T> c;
    private final String codeName;
    private final Noun name;
    private @Nullable DefaultExpression<T> defaultExpression = null;
    private @Nullable Parser<? extends T> parser = null;
    private @Nullable Cloner<T> cloner = null;
    private @Nullable Pattern[] userInputPatterns = null;
    private @Nullable Changer<? super T> changer = null;
    private @Nullable Supplier<Iterator<T>> supplier = null;
    private @Nullable Serializer<? super T> serializer = null;
    private @Nullable Class<?> serializeAs = null;
    private @Nullable Arithmetic<? super T, ?> math = null;
    private @Nullable Class<?> mathRelativeType = null;
    private @Nullable String docName = null;
    private @Nullable String[] description = null;
    private @Nullable String[] usage = null;
    private @Nullable String[] examples = null;
    private @Nullable String since = null;
    private @Nullable String[] requiredPlugins = null;
    private @Nullable String documentationId = null;
    public static final String NO_DOC = new String();
    private @Nullable Set<String> before;
    private final Set<String> after = new HashSet<String>();

    public ClassInfo(Class<T> c, String codeName) {
        this.c = c;
        if (!ClassInfo.isValidCodeName(codeName)) {
            throw new IllegalArgumentException("Code names for classes must be lowercase and only consist of latin letters and arabic numbers");
        }
        this.codeName = codeName;
        this.name = new Noun("types." + codeName);
    }

    @Deprecated
    public static boolean isVaildCodeName(String name) {
        return ClassInfo.isValidCodeName(name);
    }

    public static boolean isValidCodeName(String name) {
        return name.matches("[a-z0-9]+");
    }

    public ClassInfo<T> parser(Parser<? extends T> parser) {
        assert (this.parser == null);
        this.parser = parser;
        return this;
    }

    public ClassInfo<T> cloner(Cloner<T> cloner) {
        assert (this.cloner == null);
        this.cloner = cloner;
        return this;
    }

    public ClassInfo<T> user(String ... userInputPatterns) throws PatternSyntaxException {
        assert (this.userInputPatterns == null);
        this.userInputPatterns = new Pattern[userInputPatterns.length];
        for (int i = 0; i < userInputPatterns.length; ++i) {
            assert (this.userInputPatterns != null);
            this.userInputPatterns[i] = Pattern.compile(userInputPatterns[i]);
        }
        return this;
    }

    public ClassInfo<T> defaultExpression(DefaultExpression<T> defaultExpression) {
        assert (this.defaultExpression == null);
        if (!defaultExpression.isDefault()) {
            throw new IllegalArgumentException("defaultExpression.isDefault() must return true for the default expression of a class");
        }
        this.defaultExpression = defaultExpression;
        return this;
    }

    public ClassInfo<T> supplier(Supplier<Iterator<T>> supplier) {
        if (this.supplier != null) {
            throw new SkriptAPIException("supplier of this class is already set");
        }
        this.supplier = supplier;
        return this;
    }

    public ClassInfo<T> supplier(T[] values) {
        return this.supplier(() -> new ArrayIterator<Object>(values));
    }

    public ClassInfo<T> serializer(Serializer<? super T> serializer) {
        assert (this.serializer == null);
        if (this.serializeAs != null) {
            throw new IllegalStateException("Can't set a serializer if this class is set to be serialized as another one");
        }
        this.serializer = serializer;
        serializer.register(this);
        return this;
    }

    public ClassInfo<T> serializeAs(Class<?> serializeAs) {
        assert (this.serializeAs == null);
        if (this.serializer != null) {
            throw new IllegalStateException("Can't set this class to be serialized as another one if a serializer is already set");
        }
        this.serializeAs = serializeAs;
        return this;
    }

    @Deprecated
    public ClassInfo<T> changer(SerializableChanger<? super T> changer) {
        return this.changer((Changer<? super T>)changer);
    }

    public ClassInfo<T> changer(Changer<? super T> changer) {
        assert (this.changer == null);
        this.changer = changer;
        return this;
    }

    @Deprecated
    public <R> ClassInfo<T> math(Class<R> relativeType, Arithmetic<? super T, R> math) {
        assert (this.math == null);
        this.math = math;
        this.mathRelativeType = relativeType;
        Arithmetics.registerOperation(Operator.ADDITION, this.c, relativeType, (left, right) -> math.add((Object)left, (Object)right));
        Arithmetics.registerOperation(Operator.SUBTRACTION, this.c, relativeType, (left, right) -> math.subtract((Object)left, (Object)right));
        Arithmetics.registerOperation(Operator.MULTIPLICATION, this.c, relativeType, (left, right) -> math.multiply((Object)left, (Object)right));
        Arithmetics.registerOperation(Operator.DIVISION, this.c, relativeType, (left, right) -> math.divide((Object)left, (Object)right));
        Arithmetics.registerOperation(Operator.EXPONENTIATION, this.c, relativeType, (left, right) -> math.power((Object)left, (Object)right));
        Arithmetics.registerDifference(this.c, relativeType, math::difference);
        return this;
    }

    public ClassInfo<T> name(String name) {
        assert (this.docName == null);
        this.docName = name;
        return this;
    }

    public ClassInfo<T> description(String ... description) {
        assert (this.description == null);
        this.description = description;
        return this;
    }

    public ClassInfo<T> usage(String ... usage) {
        assert (this.usage == null);
        this.usage = usage;
        return this;
    }

    public ClassInfo<T> examples(String ... examples) {
        assert (this.examples == null);
        this.examples = examples;
        return this;
    }

    public ClassInfo<T> since(String since) {
        assert (this.since == null);
        this.since = since;
        return this;
    }

    public ClassInfo<T> requiredPlugins(String ... pluginNames) {
        assert (this.requiredPlugins == null);
        this.requiredPlugins = pluginNames;
        return this;
    }

    public ClassInfo<T> documentationId(String id) {
        assert (this.documentationId == null);
        this.documentationId = id;
        return this;
    }

    public Class<T> getC() {
        return this.c;
    }

    public Noun getName() {
        return this.name;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public @Nullable DefaultExpression<T> getDefaultExpression() {
        return this.defaultExpression;
    }

    public @Nullable Parser<? extends T> getParser() {
        return this.parser;
    }

    public @Nullable Cloner<? extends T> getCloner() {
        return this.cloner;
    }

    public T clone(T t) {
        return this.cloner == null ? t : this.cloner.clone(t);
    }

    public @Nullable Pattern[] getUserInputPatterns() {
        return this.userInputPatterns;
    }

    public @Nullable Changer<? super T> getChanger() {
        return this.changer;
    }

    public @Nullable Supplier<Iterator<T>> getSupplier() {
        if (this.supplier == null && this.c.isEnum()) {
            this.supplier = () -> new ArrayIterator<T>(this.c.getEnumConstants());
        }
        return this.supplier;
    }

    public @Nullable Serializer<? super T> getSerializer() {
        return this.serializer;
    }

    public @Nullable Class<?> getSerializeAs() {
        return this.serializeAs;
    }

    @Deprecated
    public @Nullable Arithmetic<? super T, ?> getMath() {
        return this.math;
    }

    @Deprecated
    public <R> @Nullable Arithmetic<T, R> getRelativeMath() {
        return this.math;
    }

    @Deprecated
    public @Nullable Class<?> getMathRelativeType() {
        return this.mathRelativeType;
    }

    public @Nullable String[] getDescription() {
        return this.description;
    }

    public @Nullable String[] getUsage() {
        return this.usage;
    }

    public @Nullable String[] getExamples() {
        return this.examples;
    }

    public @Nullable String getSince() {
        return this.since;
    }

    public @Nullable String getDocName() {
        return this.docName;
    }

    public @Nullable String[] getRequiredPlugins() {
        return this.requiredPlugins;
    }

    public @Nullable String getDocumentationID() {
        return this.documentationId;
    }

    public boolean hasDocs() {
        return this.getDocName() != null && !NO_DOC.equals(this.getDocName());
    }

    public ClassInfo<T> before(String ... before) {
        assert (this.before == null);
        this.before = new HashSet<String>(Arrays.asList(before));
        return this;
    }

    public ClassInfo<T> after(String ... after) {
        this.after.addAll(Arrays.asList(after));
        return this;
    }

    public @Nullable Set<String> before() {
        return this.before;
    }

    public Set<String> after() {
        return this.after;
    }

    @Override
    public @NonNull String toString() {
        return this.getName().getSingular();
    }

    public String toString(int flags) {
        return this.getName().toString(flags);
    }

    @Override
    public @NonNull String toString(@Nullable Event event, boolean debug) {
        if (debug) {
            return this.codeName + " (" + this.c.getCanonicalName() + ")";
        }
        return this.getName().getSingular();
    }
}

