/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.events.bukkit.ScriptEvent;
import ch.njol.skript.events.bukkit.SkriptStartEvent;
import ch.njol.skript.events.bukkit.SkriptStopEvent;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.BlockStateBlock;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.DelayedChangeBlock;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.slot.EquipmentSlot;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.skript.util.slot.SlotWithIndex;
import com.destroystokyo.paper.event.block.AnvilDamagedEvent;
import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.event.player.PlayerStonecutterRecipeSelectEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import io.papermc.paper.event.player.PlayerTradeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.WeatherEvent;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

public final class BukkitEventValues {
    private static final ItemStack AIR_IS = new ItemStack(Material.AIR);

    static {
        EventValues.registerEventValue(WorldEvent.class, World.class, new Getter<World, WorldEvent>(){

            @Override
            public @Nullable World get(WorldEvent e) {
                return e.getWorld();
            }
        }, 0);
        EventValues.registerEventValue(StructureGrowEvent.class, Block.class, new Getter<Block, StructureGrowEvent>(){

            @Override
            public @Nullable Block get(StructureGrowEvent e) {
                return e.getLocation().getBlock();
            }
        }, 0);
        EventValues.registerEventValue(StructureGrowEvent.class, Block[].class, new Getter<Block[], StructureGrowEvent>(){

            @Override
            public @Nullable Block[] get(StructureGrowEvent event) {
                return (Block[])event.getBlocks().stream().map(BlockState::getBlock).toArray(Block[]::new);
            }
        }, 0);
        EventValues.registerEventValue(StructureGrowEvent.class, Block.class, new Getter<Block, StructureGrowEvent>(){

            @Override
            public @Nullable Block get(StructureGrowEvent event) {
                for (BlockState bs : event.getBlocks()) {
                    if (!bs.getLocation().equals((Object)event.getLocation())) continue;
                    return new BlockStateBlock(bs);
                }
                return event.getLocation().getBlock();
            }
        }, 1);
        EventValues.registerEventValue(StructureGrowEvent.class, Block[].class, new Getter<Block[], StructureGrowEvent>(){

            @Override
            public @Nullable Block[] get(StructureGrowEvent event) {
                return (Block[])event.getBlocks().stream().map(BlockStateBlock::new).toArray(Block[]::new);
            }
        }, 1);
        EventValues.registerEventValue(WeatherEvent.class, World.class, new Getter<World, WeatherEvent>(){

            @Override
            public @Nullable World get(WeatherEvent e) {
                return e.getWorld();
            }
        }, 0);
        EventValues.registerEventValue(ChunkEvent.class, Chunk.class, new Getter<Chunk, ChunkEvent>(){

            @Override
            public @Nullable Chunk get(ChunkEvent e) {
                return e.getChunk();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, Block.class, new Getter<Block, BlockEvent>(){

            @Override
            public @Nullable Block get(BlockEvent e) {
                return e.getBlock();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, World.class, new Getter<World, BlockEvent>(){

            @Override
            public @Nullable World get(BlockEvent e) {
                return e.getBlock().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, Location.class, new Getter<Location, BlockEvent>(){

            @Override
            public @Nullable Location get(BlockEvent e) {
                return BlockUtils.getLocation(e.getBlock());
            }
        }, 0);
        EventValues.registerEventValue(BlockPlaceEvent.class, Player.class, new Getter<Player, BlockPlaceEvent>(){

            @Override
            public @Nullable Player get(BlockPlaceEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockPlaceEvent.class, ItemStack.class, new Getter<ItemStack, BlockPlaceEvent>(){

            @Override
            public @Nullable ItemStack get(BlockPlaceEvent event) {
                return event.getItemInHand();
            }
        }, -1);
        EventValues.registerEventValue(BlockPlaceEvent.class, ItemStack.class, new Getter<ItemStack, BlockPlaceEvent>(){

            @Override
            public @Nullable ItemStack get(BlockPlaceEvent event) {
                return event.getItemInHand();
            }
        }, 0);
        EventValues.registerEventValue(BlockPlaceEvent.class, ItemStack.class, new Getter<ItemStack, BlockPlaceEvent>(){

            @Override
            public @Nullable ItemStack get(BlockPlaceEvent event) {
                ItemStack item = event.getItemInHand().clone();
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    item.setAmount(item.getAmount() - 1);
                }
                return item;
            }
        }, 1);
        EventValues.registerEventValue(BlockPlaceEvent.class, Block.class, new Getter<Block, BlockPlaceEvent>(){

            @Override
            public Block get(BlockPlaceEvent e) {
                return new BlockStateBlock(e.getBlockReplacedState());
            }
        }, -1);
        EventValues.registerEventValue(BlockPlaceEvent.class, Direction.class, new Getter<Direction, BlockPlaceEvent>(){

            @Override
            public @Nullable Direction get(BlockPlaceEvent e) {
                BlockFace bf = e.getBlockPlaced().getFace(e.getBlockAgainst());
                if (bf != null) {
                    return new Direction(new double[]{bf.getModX(), bf.getModY(), bf.getModZ()});
                }
                return Direction.ZERO;
            }
        }, 0);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            public @Nullable Block get(BlockFadeEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return new DelayedChangeBlock(e.getBlock(), e.getNewState());
            }
        }, 0);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return new BlockStateBlock(e.getNewState());
            }
        }, 1);
        EventValues.registerEventValue(BlockGrowEvent.class, Block.class, new Getter<Block, BlockGrowEvent>(){

            @Override
            public @Nullable Block get(BlockGrowEvent e) {
                return new BlockStateBlock(e.getNewState());
            }
        }, 0);
        EventValues.registerEventValue(BlockGrowEvent.class, Block.class, new Getter<Block, BlockGrowEvent>(){

            @Override
            public @Nullable Block get(BlockGrowEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockDamageEvent.class, Player.class, new Getter<Player, BlockDamageEvent>(){

            @Override
            public @Nullable Player get(BlockDamageEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockBreakEvent.class, Player.class, new Getter<Player, BlockBreakEvent>(){

            @Override
            public @Nullable Player get(BlockBreakEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            public @Nullable Block get(BlockBreakEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                return new DelayedChangeBlock(e.getBlock());
            }
        }, 0);
        final ItemType stationaryWater = Aliases.javaItemType("stationary water");
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                BlockState s;
                s.setType((s = e.getBlock().getState()).getType() == Material.ICE ? stationaryWater.getMaterial() : Material.AIR);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 1);
        EventValues.registerEventValue(BlockFromToEvent.class, Block.class, new Getter<Block, BlockFromToEvent>(){

            @Override
            public @Nullable Block get(BlockFromToEvent e) {
                return e.getToBlock();
            }
        }, 1);
        EventValues.registerEventValue(BlockIgniteEvent.class, Player.class, new Getter<Player, BlockIgniteEvent>(){

            @Override
            public @Nullable Player get(BlockIgniteEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockIgniteEvent.class, Block.class, new Getter<Block, BlockIgniteEvent>(){

            @Override
            public @Nullable Block get(BlockIgniteEvent e) {
                return e.getIgnitingBlock();
            }
        }, 0);
        EventValues.registerEventValue(BlockDispenseEvent.class, ItemStack.class, new Getter<ItemStack, BlockDispenseEvent>(){

            @Override
            public @Nullable ItemStack get(BlockDispenseEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(BlockCanBuildEvent.class, Block.class, new Getter<Block, BlockCanBuildEvent>(){

            @Override
            public @Nullable Block get(BlockCanBuildEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockCanBuildEvent.class, Block.class, new Getter<Block, BlockCanBuildEvent>(){

            @Override
            public Block get(BlockCanBuildEvent e) {
                BlockState s = e.getBlock().getState();
                s.setType(e.getMaterial());
                return new BlockStateBlock(s, true);
            }
        }, 0);
        if (Skript.methodExists(BlockCanBuildEvent.class, "getPlayer", new Class[0])) {
            EventValues.registerEventValue(BlockCanBuildEvent.class, Player.class, new Getter<Player, BlockCanBuildEvent>(){

                @Override
                public @Nullable Player get(BlockCanBuildEvent e) {
                    return e.getPlayer();
                }
            }, 0);
        }
        EventValues.registerEventValue(SignChangeEvent.class, Player.class, new Getter<Player, SignChangeEvent>(){

            @Override
            public @Nullable Player get(SignChangeEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(SignChangeEvent.class, String[].class, new Getter<String[], SignChangeEvent>(){

            @Override
            public @Nullable String[] get(SignChangeEvent event) {
                return event.getLines();
            }
        }, 0);
        EventValues.registerEventValue(EntityEvent.class, Entity.class, new Getter<Entity, EntityEvent>(){

            @Override
            public @Nullable Entity get(EntityEvent e) {
                return e.getEntity();
            }
        }, 0, "Use 'attacker' and/or 'victim' in damage/death events", EntityDamageEvent.class, EntityDeathEvent.class);
        EventValues.registerEventValue(EntityEvent.class, CommandSender.class, new Getter<CommandSender, EntityEvent>(){

            @Override
            public @Nullable CommandSender get(EntityEvent e) {
                return e.getEntity();
            }
        }, 0, "Use 'attacker' and/or 'victim' in damage/death events", EntityDamageEvent.class, EntityDeathEvent.class);
        EventValues.registerEventValue(EntityEvent.class, World.class, new Getter<World, EntityEvent>(){

            @Override
            public @Nullable World get(EntityEvent e) {
                return e.getEntity().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(EntityEvent.class, Location.class, new Getter<Location, EntityEvent>(){

            @Override
            public @Nullable Location get(EntityEvent e) {
                return e.getEntity().getLocation();
            }
        }, 0);
        EventValues.registerEventValue(EntityDamageEvent.class, EntityDamageEvent.DamageCause.class, new Getter<EntityDamageEvent.DamageCause, EntityDamageEvent>(){

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable EntityDamageEvent.DamageCause get(EntityDamageEvent e) {
                return e.getCause();
            }
        }, 0);
        EventValues.registerEventValue(EntityDamageByEntityEvent.class, Projectile.class, new Getter<Projectile, EntityDamageByEntityEvent>(){

            @Override
            public @Nullable Projectile get(EntityDamageByEntityEvent e) {
                if (e.getDamager() instanceof Projectile) {
                    return (Projectile)e.getDamager();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(EntityDeathEvent.class, ItemStack[].class, new Getter<ItemStack[], EntityDeathEvent>(){

            @Override
            public @Nullable ItemStack[] get(EntityDeathEvent event) {
                return event.getDrops().toArray(new ItemStack[0]);
            }
        }, 0);
        EventValues.registerEventValue(EntityDeathEvent.class, Projectile.class, new Getter<Projectile, EntityDeathEvent>(){

            @Override
            public @Nullable Projectile get(EntityDeathEvent e) {
                EntityDamageEvent ldc = e.getEntity().getLastDamageCause();
                if (ldc instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)ldc).getDamager() instanceof Projectile) {
                    return (Projectile)((EntityDamageByEntityEvent)ldc).getDamager();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(EntityDeathEvent.class, EntityDamageEvent.DamageCause.class, new Getter<EntityDamageEvent.DamageCause, EntityDeathEvent>(){

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable EntityDamageEvent.DamageCause get(EntityDeathEvent e) {
                EntityDamageEvent ldc = e.getEntity().getLastDamageCause();
                return ldc == null ? null : ldc.getCause();
            }
        }, 0);
        if (Skript.methodExists(ProjectileHitEvent.class, "getHitBlock", new Class[0])) {
            EventValues.registerEventValue(ProjectileHitEvent.class, Block.class, new Getter<Block, ProjectileHitEvent>(){

                @Override
                public @Nullable Block get(ProjectileHitEvent e) {
                    return e.getHitBlock();
                }
            }, 0);
        }
        EventValues.registerEventValue(ProjectileHitEvent.class, Entity.class, new Getter<Entity, ProjectileHitEvent>(){

            @Override
            public @Nullable Entity get(ProjectileHitEvent e) {
                assert (false);
                return e.getEntity();
            }
        }, 0, "Use 'projectile' and/or 'shooter' in projectile hit events", ProjectileHitEvent.class);
        EventValues.registerEventValue(ProjectileHitEvent.class, Projectile.class, new Getter<Projectile, ProjectileHitEvent>(){

            @Override
            public @Nullable Projectile get(ProjectileHitEvent e) {
                return e.getEntity();
            }
        }, 0);
        if (Skript.methodExists(ProjectileHitEvent.class, "getHitBlockFace", new Class[0])) {
            EventValues.registerEventValue(ProjectileHitEvent.class, Direction.class, new Getter<Direction, ProjectileHitEvent>(){

                @Override
                public @Nullable Direction get(ProjectileHitEvent e) {
                    BlockFace theHitFace = e.getHitBlockFace();
                    if (theHitFace == null) {
                        return null;
                    }
                    return new Direction(theHitFace, 1.0);
                }
            }, 0);
        }
        EventValues.registerEventValue(ProjectileLaunchEvent.class, Entity.class, new Getter<Entity, ProjectileLaunchEvent>(){

            @Override
            public @Nullable Entity get(ProjectileLaunchEvent e) {
                assert (false);
                return e.getEntity();
            }
        }, 0, "Use 'projectile' and/or 'shooter' in shoot events", ProjectileLaunchEvent.class);
        if (Skript.classExists("com.destroystokyo.paper.event.entity.ProjectileCollideEvent")) {
            EventValues.registerEventValue(ProjectileCollideEvent.class, Projectile.class, new Getter<Projectile, ProjectileCollideEvent>(){

                @Override
                public @Nullable Projectile get(ProjectileCollideEvent evt) {
                    return evt.getEntity();
                }
            }, 0);
            EventValues.registerEventValue(ProjectileCollideEvent.class, Entity.class, new Getter<Entity, ProjectileCollideEvent>(){

                @Override
                public @Nullable Entity get(ProjectileCollideEvent evt) {
                    return evt.getCollidedWith();
                }
            }, 0);
        }
        EventValues.registerEventValue(ProjectileLaunchEvent.class, Projectile.class, new Getter<Projectile, ProjectileLaunchEvent>(){

            @Override
            public @Nullable Projectile get(ProjectileLaunchEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(EntityTameEvent.class, Entity.class, new Getter<Entity, EntityTameEvent>(){

            @Override
            public @Nullable Entity get(EntityTameEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(EntityChangeBlockEvent.class, Block.class, new Getter<Block, EntityChangeBlockEvent>(){

            @Override
            public @Nullable Block get(EntityChangeBlockEvent event) {
                return event.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(EntityChangeBlockEvent.class, Block.class, new Getter<Block, EntityChangeBlockEvent>(){

            @Override
            public @Nullable Block get(EntityChangeBlockEvent event) {
                return event.getBlock();
            }
        }, 0);
        EventValues.registerEventValue(EntityChangeBlockEvent.class, BlockData.class, new Getter<BlockData, EntityChangeBlockEvent>(){

            @Override
            public @Nullable BlockData get(EntityChangeBlockEvent event) {
                return event.getBlockData();
            }
        }, 0);
        EventValues.registerEventValue(EntityChangeBlockEvent.class, BlockData.class, new Getter<BlockData, EntityChangeBlockEvent>(){

            @Override
            public @Nullable BlockData get(EntityChangeBlockEvent event) {
                return event.getBlockData();
            }
        }, 1);
        EventValues.registerEventValue(AreaEffectCloudApplyEvent.class, LivingEntity[].class, new Getter<LivingEntity[], AreaEffectCloudApplyEvent>(){

            @Override
            public @Nullable LivingEntity[] get(AreaEffectCloudApplyEvent event) {
                return event.getAffectedEntities().toArray(new LivingEntity[0]);
            }
        }, 0);
        EventValues.registerEventValue(AreaEffectCloudApplyEvent.class, PotionEffectType.class, new Getter<PotionEffectType, AreaEffectCloudApplyEvent>(){

            @Override
            public @Nullable PotionEffectType get(AreaEffectCloudApplyEvent e) {
                return e.getEntity().getBasePotionData().getType().getEffectType();
            }
        }, 0);
        EventValues.registerEventValue(ItemSpawnEvent.class, ItemStack.class, new Getter<ItemStack, ItemSpawnEvent>(){

            @Override
            public @Nullable ItemStack get(ItemSpawnEvent e) {
                return e.getEntity().getItemStack();
            }
        }, 0);
        EventValues.registerEventValue(LightningStrikeEvent.class, Entity.class, new Getter<Entity, LightningStrikeEvent>(){

            @Override
            public Entity get(LightningStrikeEvent event) {
                return event.getLightning();
            }
        }, 0);
        EventValues.registerEventValue(PlayerEvent.class, Player.class, new Getter<Player, PlayerEvent>(){

            @Override
            public @Nullable Player get(PlayerEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(PlayerEvent.class, World.class, new Getter<World, PlayerEvent>(){

            @Override
            public @Nullable World get(PlayerEvent e) {
                return e.getPlayer().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBedEnterEvent.class, Block.class, new Getter<Block, PlayerBedEnterEvent>(){

            @Override
            public @Nullable Block get(PlayerBedEnterEvent e) {
                return e.getBed();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBedLeaveEvent.class, Block.class, new Getter<Block, PlayerBedLeaveEvent>(){

            @Override
            public @Nullable Block get(PlayerBedLeaveEvent e) {
                return e.getBed();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBucketFillEvent.class, Block.class, new Getter<Block, PlayerBucketFillEvent>(){

            @Override
            public @Nullable Block get(PlayerBucketFillEvent e) {
                return e.getBlockClicked().getRelative(e.getBlockFace());
            }
        }, 0);
        EventValues.registerEventValue(PlayerBucketFillEvent.class, Block.class, new Getter<Block, PlayerBucketFillEvent>(){

            @Override
            public @Nullable Block get(PlayerBucketFillEvent e) {
                BlockState s = e.getBlockClicked().getRelative(e.getBlockFace()).getState();
                s.setType(Material.AIR);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 1);
        EventValues.registerEventValue(PlayerBucketEmptyEvent.class, Block.class, new Getter<Block, PlayerBucketEmptyEvent>(){

            @Override
            public @Nullable Block get(PlayerBucketEmptyEvent e) {
                return e.getBlockClicked().getRelative(e.getBlockFace());
            }
        }, -1);
        final ItemType stationaryLava = Aliases.javaItemType("stationary lava");
        EventValues.registerEventValue(PlayerBucketEmptyEvent.class, Block.class, new Getter<Block, PlayerBucketEmptyEvent>(){

            @Override
            public Block get(PlayerBucketEmptyEvent e) {
                BlockState s = e.getBlockClicked().getRelative(e.getBlockFace()).getState();
                s.setType(e.getBucket() == Material.WATER_BUCKET ? stationaryWater.getMaterial() : stationaryLava.getMaterial());
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 0);
        EventValues.registerEventValue(PlayerDropItemEvent.class, Player.class, new Getter<Player, PlayerDropItemEvent>(){

            @Override
            public @Nullable Player get(PlayerDropItemEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(PlayerDropItemEvent.class, Item.class, new Getter<Item, PlayerDropItemEvent>(){

            @Override
            public @Nullable Item get(PlayerDropItemEvent e) {
                return e.getItemDrop();
            }
        }, 0);
        EventValues.registerEventValue(PlayerDropItemEvent.class, ItemStack.class, new Getter<ItemStack, PlayerDropItemEvent>(){

            @Override
            public @Nullable ItemStack get(PlayerDropItemEvent e) {
                return e.getItemDrop().getItemStack();
            }
        }, 0);
        EventValues.registerEventValue(PlayerPickupItemEvent.class, Player.class, new Getter<Player, PlayerPickupItemEvent>(){

            @Override
            public @Nullable Player get(PlayerPickupItemEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(PlayerPickupItemEvent.class, Item.class, new Getter<Item, PlayerPickupItemEvent>(){

            @Override
            public @Nullable Item get(PlayerPickupItemEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(PlayerPickupItemEvent.class, ItemStack.class, new Getter<ItemStack, PlayerPickupItemEvent>(){

            @Override
            public @Nullable ItemStack get(PlayerPickupItemEvent e) {
                return e.getItem().getItemStack();
            }
        }, 0);
        EventValues.registerEventValue(EntityPickupItemEvent.class, Entity.class, new Getter<Entity, EntityPickupItemEvent>(){

            @Override
            public @Nullable Entity get(EntityPickupItemEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(EntityPickupItemEvent.class, Item.class, new Getter<Item, EntityPickupItemEvent>(){

            @Override
            public @Nullable Item get(EntityPickupItemEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(EntityPickupItemEvent.class, ItemType.class, new Getter<ItemType, EntityPickupItemEvent>(){

            @Override
            public @Nullable ItemType get(EntityPickupItemEvent e) {
                return new ItemType(e.getItem().getItemStack());
            }
        }, 0);
        EventValues.registerEventValue(PlayerItemConsumeEvent.class, ItemStack.class, new Getter<ItemStack, PlayerItemConsumeEvent>(){

            @Override
            public @Nullable ItemStack get(PlayerItemConsumeEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(PlayerItemBreakEvent.class, ItemStack.class, new Getter<ItemStack, PlayerItemBreakEvent>(){

            @Override
            public @Nullable ItemStack get(PlayerItemBreakEvent e) {
                return e.getBrokenItem();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEntityEvent.class, Entity.class, new Getter<Entity, PlayerInteractEntityEvent>(){

            @Override
            public @Nullable Entity get(PlayerInteractEntityEvent e) {
                return e.getRightClicked();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEntityEvent.class, ItemStack.class, new Getter<ItemStack, PlayerInteractEntityEvent>(){

            @Override
            public @Nullable ItemStack get(PlayerInteractEntityEvent e) {
                org.bukkit.inventory.EquipmentSlot hand = e.getHand();
                if (hand == org.bukkit.inventory.EquipmentSlot.HAND) {
                    return e.getPlayer().getInventory().getItemInMainHand();
                }
                if (hand == org.bukkit.inventory.EquipmentSlot.OFF_HAND) {
                    return e.getPlayer().getInventory().getItemInOffHand();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEvent.class, ItemStack.class, new Getter<ItemStack, PlayerInteractEvent>(){

            @Override
            public @Nullable ItemStack get(PlayerInteractEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEvent.class, Block.class, new Getter<Block, PlayerInteractEvent>(){

            @Override
            public @Nullable Block get(PlayerInteractEvent e) {
                return e.getClickedBlock();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEvent.class, Direction.class, new Getter<Direction, PlayerInteractEvent>(){

            @Override
            public @Nullable Direction get(PlayerInteractEvent e) {
                return new Direction(new double[]{e.getBlockFace().getModX(), e.getBlockFace().getModY(), e.getBlockFace().getModZ()});
            }
        }, 0);
        EventValues.registerEventValue(PlayerShearEntityEvent.class, Entity.class, new Getter<Entity, PlayerShearEntityEvent>(){

            @Override
            public @Nullable Entity get(PlayerShearEntityEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(PlayerMoveEvent.class, Block.class, new Getter<Block, PlayerMoveEvent>(){

            @Override
            public Block get(PlayerMoveEvent event) {
                return event.getTo().clone().subtract(0.0, 0.5, 0.0).getBlock();
            }
        }, 0);
        EventValues.registerEventValue(PlayerMoveEvent.class, Location.class, new Getter<Location, PlayerMoveEvent>(){

            @Override
            public Location get(PlayerMoveEvent event) {
                return event.getFrom();
            }
        }, -1);
        EventValues.registerEventValue(PlayerMoveEvent.class, Location.class, new Getter<Location, PlayerMoveEvent>(){

            @Override
            public Location get(PlayerMoveEvent event) {
                return event.getTo();
            }
        }, 0);
        EventValues.registerEventValue(PlayerMoveEvent.class, Chunk.class, new Getter<Chunk, PlayerMoveEvent>(){

            @Override
            public Chunk get(PlayerMoveEvent event) {
                return event.getFrom().getChunk();
            }
        }, -1);
        EventValues.registerEventValue(PlayerMoveEvent.class, Chunk.class, new Getter<Chunk, PlayerMoveEvent>(){

            @Override
            public Chunk get(PlayerMoveEvent event) {
                return event.getTo().getChunk();
            }
        }, 0);
        EventValues.registerEventValue(PlayerItemDamageEvent.class, ItemStack.class, new Getter<ItemStack, PlayerItemDamageEvent>(){

            @Override
            public ItemStack get(PlayerItemDamageEvent event) {
                return event.getItem();
            }
        }, 0);
        EventValues.registerEventValue(PlayerItemMendEvent.class, Player.class, new Getter<Player, PlayerItemMendEvent>(){

            @Override
            public @Nullable Player get(PlayerItemMendEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(PlayerItemMendEvent.class, ItemStack.class, new Getter<ItemStack, PlayerItemMendEvent>(){

            @Override
            public @Nullable ItemStack get(PlayerItemMendEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(PlayerItemMendEvent.class, Entity.class, new Getter<Entity, PlayerItemMendEvent>(){

            @Override
            public @Nullable Entity get(PlayerItemMendEvent e) {
                return e.getExperienceOrb();
            }
        }, 0);
        EventValues.registerEventValue(HangingEvent.class, Hanging.class, new Getter<Hanging, HangingEvent>(){

            @Override
            public @Nullable Hanging get(HangingEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(HangingEvent.class, World.class, new Getter<World, HangingEvent>(){

            @Override
            public @Nullable World get(HangingEvent e) {
                return e.getEntity().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(HangingEvent.class, Location.class, new Getter<Location, HangingEvent>(){

            @Override
            public @Nullable Location get(HangingEvent e) {
                return e.getEntity().getLocation();
            }
        }, 0);
        EventValues.registerEventValue(HangingBreakEvent.class, Entity.class, new Getter<Entity, HangingBreakEvent>(){

            @Override
            public @Nullable Entity get(HangingBreakEvent e) {
                if (e instanceof HangingBreakByEntityEvent) {
                    return ((HangingBreakByEntityEvent)e).getRemover();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(HangingPlaceEvent.class, Player.class, new Getter<Player, HangingPlaceEvent>(){

            @Override
            public @Nullable Player get(HangingPlaceEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEvent.class, Vehicle.class, new Getter<Vehicle, VehicleEvent>(){

            @Override
            public @Nullable Vehicle get(VehicleEvent e) {
                return e.getVehicle();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEvent.class, World.class, new Getter<World, VehicleEvent>(){

            @Override
            public @Nullable World get(VehicleEvent e) {
                return e.getVehicle().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(VehicleExitEvent.class, LivingEntity.class, new Getter<LivingEntity, VehicleExitEvent>(){

            @Override
            public @Nullable LivingEntity get(VehicleExitEvent e) {
                return e.getExited();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEnterEvent.class, Entity.class, new Getter<Entity, VehicleEnterEvent>(){

            @Override
            public @Nullable Entity get(VehicleEnterEvent e) {
                return e.getEntered();
            }
        }, 0);
        EventValues.registerEventValue(VehicleDamageEvent.class, Entity.class, new Getter<Entity, VehicleDamageEvent>(){

            @Override
            public @Nullable Entity get(VehicleDamageEvent e) {
                return e.getAttacker();
            }
        }, 0);
        EventValues.registerEventValue(VehicleDestroyEvent.class, Entity.class, new Getter<Entity, VehicleDestroyEvent>(){

            @Override
            public @Nullable Entity get(VehicleDestroyEvent e) {
                return e.getAttacker();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEvent.class, Entity.class, new Getter<Entity, VehicleEvent>(){

            @Override
            public @Nullable Entity get(VehicleEvent e) {
                return e.getVehicle().getPassenger();
            }
        }, 0);
        EventValues.registerEventValue(ServerCommandEvent.class, CommandSender.class, new Getter<CommandSender, ServerCommandEvent>(){

            @Override
            public @Nullable CommandSender get(ServerCommandEvent e) {
                return e.getSender();
            }
        }, 0);
        EventValues.registerEventValue(CommandEvent.class, String[].class, new Getter<String[], CommandEvent>(){

            @Override
            public String[] get(CommandEvent event) {
                return event.getArgs();
            }
        }, 0);
        EventValues.registerEventValue(CommandEvent.class, CommandSender.class, new Getter<CommandSender, CommandEvent>(){

            @Override
            public CommandSender get(CommandEvent e) {
                return e.getSender();
            }
        }, 0);
        EventValues.registerEventValue(CommandEvent.class, World.class, new Getter<World, CommandEvent>(){

            @Override
            public @Nullable World get(CommandEvent e) {
                return e.getSender() instanceof Player ? ((Player)e.getSender()).getWorld() : null;
            }
        }, 0);
        EventValues.registerEventValue(ScriptEvent.class, CommandSender.class, new Getter<CommandSender, ScriptEvent>(){

            @Override
            public @Nullable CommandSender get(ScriptEvent e) {
                return Bukkit.getConsoleSender();
            }
        }, 0);
        EventValues.registerEventValue(SkriptStartEvent.class, CommandSender.class, new Getter<CommandSender, SkriptStartEvent>(){

            @Override
            public @Nullable CommandSender get(SkriptStartEvent e) {
                return Bukkit.getConsoleSender();
            }
        }, 0);
        EventValues.registerEventValue(SkriptStopEvent.class, CommandSender.class, new Getter<CommandSender, SkriptStopEvent>(){

            @Override
            public @Nullable CommandSender get(SkriptStopEvent e) {
                return Bukkit.getConsoleSender();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, Player.class, new Getter<Player, InventoryClickEvent>(){

            @Override
            public @Nullable Player get(InventoryClickEvent e) {
                return e.getWhoClicked() instanceof Player ? (Player)e.getWhoClicked() : null;
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, World.class, new Getter<World, InventoryClickEvent>(){

            @Override
            public @Nullable World get(InventoryClickEvent e) {
                return e.getWhoClicked().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, ItemStack.class, new Getter<ItemStack, InventoryClickEvent>(){

            @Override
            public @Nullable ItemStack get(InventoryClickEvent e) {
                if (e instanceof CraftItemEvent) {
                    return ((CraftItemEvent)e).getRecipe().getResult();
                }
                return e.getCurrentItem();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, Slot.class, new Getter<Slot, InventoryClickEvent>(){

            @Override
            public @Nullable Slot get(InventoryClickEvent e) {
                Inventory invi = e.getClickedInventory();
                int slotIndex = e.getSlot();
                if (invi instanceof PlayerInventory && slotIndex >= 36) {
                    return new EquipmentSlot(((PlayerInventory)invi).getHolder(), slotIndex);
                }
                return new InventorySlot(invi, slotIndex, e.getRawSlot());
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, InventoryAction.class, new Getter<InventoryAction, InventoryClickEvent>(){

            @Override
            public @Nullable InventoryAction get(InventoryClickEvent e) {
                return e.getAction();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, ClickType.class, new Getter<ClickType, InventoryClickEvent>(){

            @Override
            public @Nullable ClickType get(InventoryClickEvent e) {
                return e.getClick();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, Inventory.class, new Getter<Inventory, InventoryClickEvent>(){

            @Override
            public @Nullable Inventory get(InventoryClickEvent e) {
                return e.getClickedInventory();
            }
        }, 0);
        EventValues.registerEventValue(InventoryDragEvent.class, Player.class, new Getter<Player, InventoryDragEvent>(){

            @Override
            public @Nullable Player get(InventoryDragEvent event) {
                return event.getWhoClicked() instanceof Player ? (Player)event.getWhoClicked() : null;
            }
        }, 0);
        EventValues.registerEventValue(InventoryDragEvent.class, World.class, new Getter<World, InventoryDragEvent>(){

            @Override
            public @Nullable World get(InventoryDragEvent event) {
                return event.getWhoClicked().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(InventoryDragEvent.class, ItemStack.class, new Getter<ItemStack, InventoryDragEvent>(){

            @Override
            public @Nullable ItemStack get(InventoryDragEvent event) {
                return event.getOldCursor();
            }
        }, -1);
        EventValues.registerEventValue(InventoryDragEvent.class, ItemStack.class, new Getter<ItemStack, InventoryDragEvent>(){

            @Override
            public @Nullable ItemStack get(InventoryDragEvent event) {
                return event.getCursor();
            }
        }, 0);
        EventValues.registerEventValue(InventoryDragEvent.class, ItemStack[].class, new Getter<ItemStack[], InventoryDragEvent>(){

            @Override
            public @Nullable ItemStack[] get(InventoryDragEvent event) {
                return event.getNewItems().values().toArray(new ItemStack[0]);
            }
        }, 0);
        EventValues.registerEventValue(InventoryDragEvent.class, Slot[].class, new Getter<Slot[], InventoryDragEvent>(){

            @Override
            public @Nullable Slot[] get(InventoryDragEvent event) {
                ArrayList<SlotWithIndex> slots = new ArrayList<SlotWithIndex>(event.getRawSlots().size());
                InventoryView view = event.getView();
                for (Integer rawSlot : event.getRawSlots()) {
                    Inventory inventory = view.getInventory(rawSlot.intValue());
                    int slot = view.convertSlot(rawSlot.intValue());
                    if (inventory == null) continue;
                    if (inventory instanceof PlayerInventory && slot >= 36) {
                        slots.add(new EquipmentSlot(((PlayerInventory)view.getBottomInventory()).getHolder(), slot));
                        continue;
                    }
                    slots.add(new InventorySlot(inventory, view.convertSlot(rawSlot.intValue())));
                }
                return slots.toArray(new Slot[0]);
            }
        }, 0);
        EventValues.registerEventValue(InventoryDragEvent.class, ClickType.class, new Getter<ClickType, InventoryDragEvent>(){

            @Override
            public @Nullable ClickType get(InventoryDragEvent event) {
                return event.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            }
        }, 0);
        EventValues.registerEventValue(InventoryDragEvent.class, Inventory[].class, new Getter<Inventory[], InventoryDragEvent>(){

            @Override
            public @Nullable Inventory[] get(InventoryDragEvent event) {
                HashSet<Inventory> inventories = new HashSet<Inventory>();
                InventoryView view = event.getView();
                for (Integer rawSlot : event.getRawSlots()) {
                    inventories.add(view.getInventory(rawSlot.intValue()));
                }
                return inventories.toArray(new Inventory[0]);
            }
        }, 0);
        EventValues.registerEventValue(PrepareAnvilEvent.class, ItemStack.class, new Getter<ItemStack, PrepareAnvilEvent>(){

            @Override
            public @Nullable ItemStack get(PrepareAnvilEvent e) {
                return e.getResult();
            }
        }, 0);
        EventValues.registerEventValue(PrepareAnvilEvent.class, Inventory.class, new Getter<Inventory, PrepareAnvilEvent>(){

            @Override
            public @Nullable Inventory get(PrepareAnvilEvent e) {
                return e.getInventory();
            }
        }, 0);
        if (Skript.classExists("com.destroystokyo.paper.event.block.AnvilDamagedEvent")) {
            EventValues.registerEventValue(AnvilDamagedEvent.class, Inventory.class, new Getter<Inventory, AnvilDamagedEvent>(){

                @Override
                public @Nullable Inventory get(AnvilDamagedEvent e) {
                    return e.getInventory();
                }
            }, 0);
        }
        EventValues.registerEventValue(BlockFertilizeEvent.class, Player.class, new Getter<Player, BlockFertilizeEvent>(){

            @Override
            public @Nullable Player get(BlockFertilizeEvent event) {
                return event.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockFertilizeEvent.class, Block[].class, new Getter<Block[], BlockFertilizeEvent>(){

            @Override
            public @Nullable Block[] get(BlockFertilizeEvent event) {
                return (Block[])event.getBlocks().stream().map(BlockState::getBlock).toArray(Block[]::new);
            }
        }, 0);
        EventValues.registerEventValue(PrepareItemCraftEvent.class, Slot.class, new Getter<Slot, PrepareItemCraftEvent>(){

            @Override
            public Slot get(PrepareItemCraftEvent e) {
                return new InventorySlot((Inventory)e.getInventory(), 0);
            }
        }, 0);
        EventValues.registerEventValue(PrepareItemCraftEvent.class, ItemStack.class, new Getter<ItemStack, PrepareItemCraftEvent>(){

            @Override
            public ItemStack get(PrepareItemCraftEvent e) {
                ItemStack item = e.getInventory().getResult();
                return item != null ? item : AIR_IS;
            }
        }, 0);
        EventValues.registerEventValue(PrepareItemCraftEvent.class, Inventory.class, new Getter<Inventory, PrepareItemCraftEvent>(){

            @Override
            public Inventory get(PrepareItemCraftEvent e) {
                return e.getInventory();
            }
        }, 0);
        EventValues.registerEventValue(PrepareItemCraftEvent.class, Player.class, new Getter<Player, PrepareItemCraftEvent>(){

            @Override
            public @Nullable Player get(PrepareItemCraftEvent e) {
                List viewers = e.getInventory().getViewers();
                if (viewers.size() == 0) {
                    return null;
                }
                HumanEntity first = (HumanEntity)viewers.get(0);
                if (first instanceof Player) {
                    return (Player)first;
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(CraftItemEvent.class, String.class, new Getter<String, CraftItemEvent>(){

            @Override
            public @Nullable String get(CraftItemEvent e) {
                Recipe recipe = e.getRecipe();
                if (recipe instanceof Keyed) {
                    return ((Keyed)recipe).getKey().toString();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(PrepareItemCraftEvent.class, String.class, new Getter<String, PrepareItemCraftEvent>(){

            @Override
            public @Nullable String get(PrepareItemCraftEvent e) {
                Recipe recipe = e.getRecipe();
                if (recipe instanceof Keyed) {
                    return ((Keyed)recipe).getKey().toString();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(CraftItemEvent.class, ItemStack.class, new Getter<ItemStack, CraftItemEvent>(){

            @Override
            public @Nullable ItemStack get(CraftItemEvent e) {
                return e.getRecipe().getResult();
            }
        }, 0);
        EventValues.registerEventValue(InventoryOpenEvent.class, Player.class, new Getter<Player, InventoryOpenEvent>(){

            @Override
            public @Nullable Player get(InventoryOpenEvent e) {
                return (Player)e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(InventoryOpenEvent.class, Inventory.class, new Getter<Inventory, InventoryOpenEvent>(){

            @Override
            public @Nullable Inventory get(InventoryOpenEvent e) {
                return e.getInventory();
            }
        }, 0);
        EventValues.registerEventValue(InventoryCloseEvent.class, Player.class, new Getter<Player, InventoryCloseEvent>(){

            @Override
            public @Nullable Player get(InventoryCloseEvent e) {
                return (Player)e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(InventoryCloseEvent.class, Inventory.class, new Getter<Inventory, InventoryCloseEvent>(){

            @Override
            public @Nullable Inventory get(InventoryCloseEvent e) {
                return e.getInventory();
            }
        }, 0);
        if (Skript.classExists("org.bukkit.event.inventory.InventoryCloseEvent$Reason")) {
            EventValues.registerEventValue(InventoryCloseEvent.class, InventoryCloseEvent.Reason.class, new Getter<InventoryCloseEvent.Reason, InventoryCloseEvent>(){

                @Override
                public InventoryCloseEvent.Reason get(InventoryCloseEvent event) {
                    return event.getReason();
                }
            }, 0);
        }
        EventValues.registerEventValue(InventoryPickupItemEvent.class, Inventory.class, new Getter<Inventory, InventoryPickupItemEvent>(){

            @Override
            public @Nullable Inventory get(InventoryPickupItemEvent event) {
                return event.getInventory();
            }
        }, 0);
        EventValues.registerEventValue(InventoryPickupItemEvent.class, Item.class, new Getter<Item, InventoryPickupItemEvent>(){

            @Override
            public @Nullable Item get(InventoryPickupItemEvent event) {
                return event.getItem();
            }
        }, 0);
        EventValues.registerEventValue(InventoryPickupItemEvent.class, ItemStack.class, new Getter<ItemStack, InventoryPickupItemEvent>(){

            @Override
            public @Nullable ItemStack get(InventoryPickupItemEvent event) {
                return event.getItem().getItemStack();
            }
        }, 0);
        EventValues.registerEventValue(PortalCreateEvent.class, World.class, new Getter<World, PortalCreateEvent>(){

            @Override
            public @Nullable World get(PortalCreateEvent e) {
                return e.getWorld();
            }
        }, 0);
        EventValues.registerEventValue(PortalCreateEvent.class, Block[].class, new Getter<Block[], PortalCreateEvent>(){

            @Override
            public @Nullable Block[] get(PortalCreateEvent event) {
                return (Block[])event.getBlocks().stream().map(BlockState::getBlock).toArray(Block[]::new);
            }
        }, 0);
        if (Skript.methodExists(PortalCreateEvent.class, "getEntity", new Class[0])) {
            EventValues.registerEventValue(PortalCreateEvent.class, Entity.class, new Getter<Entity, PortalCreateEvent>(){

                @Override
                public @Nullable Entity get(PortalCreateEvent e) {
                    return e.getEntity();
                }
            }, 0);
        }
        EventValues.registerEventValue(PlayerEditBookEvent.class, ItemStack.class, new Getter<ItemStack, PlayerEditBookEvent>(){

            @Override
            public ItemStack get(PlayerEditBookEvent event) {
                ItemStack book = new ItemStack(Material.WRITABLE_BOOK);
                book.setItemMeta((ItemMeta)event.getPreviousBookMeta());
                return book;
            }
        }, -1);
        EventValues.registerEventValue(PlayerEditBookEvent.class, ItemStack.class, new Getter<ItemStack, PlayerEditBookEvent>(){

            @Override
            public ItemStack get(PlayerEditBookEvent event) {
                ItemStack book = new ItemStack(Material.WRITABLE_BOOK);
                book.setItemMeta((ItemMeta)event.getNewBookMeta());
                return book;
            }
        }, 0);
        EventValues.registerEventValue(PlayerEditBookEvent.class, String[].class, new Getter<String[], PlayerEditBookEvent>(){

            @Override
            public String[] get(PlayerEditBookEvent event) {
                return event.getPreviousBookMeta().getPages().toArray(new String[0]);
            }
        }, -1);
        EventValues.registerEventValue(PlayerEditBookEvent.class, String[].class, new Getter<String[], PlayerEditBookEvent>(){

            @Override
            public String[] get(PlayerEditBookEvent event) {
                return event.getNewBookMeta().getPages().toArray(new String[0]);
            }
        }, 0);
        EventValues.registerEventValue(ItemDespawnEvent.class, Item.class, new Getter<Item, ItemDespawnEvent>(){

            @Override
            public @Nullable Item get(ItemDespawnEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(ItemDespawnEvent.class, ItemStack.class, new Getter<ItemStack, ItemDespawnEvent>(){

            @Override
            public @Nullable ItemStack get(ItemDespawnEvent e) {
                return e.getEntity().getItemStack();
            }
        }, 0);
        EventValues.registerEventValue(ItemMergeEvent.class, Item.class, new Getter<Item, ItemMergeEvent>(){

            @Override
            public @Nullable Item get(ItemMergeEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(ItemMergeEvent.class, Item.class, new Getter<Item, ItemMergeEvent>(){

            @Override
            public @Nullable Item get(ItemMergeEvent e) {
                return e.getTarget();
            }
        }, 1);
        EventValues.registerEventValue(ItemMergeEvent.class, ItemStack.class, new Getter<ItemStack, ItemMergeEvent>(){

            @Override
            public @Nullable ItemStack get(ItemMergeEvent e) {
                return e.getEntity().getItemStack();
            }
        }, 0);
        EventValues.registerEventValue(PlayerTeleportEvent.class, PlayerTeleportEvent.TeleportCause.class, new Getter<PlayerTeleportEvent.TeleportCause, PlayerTeleportEvent>(){

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable PlayerTeleportEvent.TeleportCause get(PlayerTeleportEvent e) {
                return e.getCause();
            }
        }, 0);
        if (Skript.classExists("io.papermc.paper.event.entity.EntityMoveEvent")) {
            EventValues.registerEventValue(EntityMoveEvent.class, Location.class, new Getter<Location, EntityMoveEvent>(){

                @Override
                public @Nullable Location get(EntityMoveEvent e) {
                    return e.getFrom();
                }
            }, 0);
            EventValues.registerEventValue(EntityMoveEvent.class, Location.class, new Getter<Location, EntityMoveEvent>(){

                @Override
                public @Nullable Location get(EntityMoveEvent e) {
                    return e.getTo();
                }
            }, 1);
        }
        EventValues.registerEventValue(PlayerToggleFlightEvent.class, Player.class, new Getter<Player, PlayerToggleFlightEvent>(){

            @Override
            public @Nullable Player get(PlayerToggleFlightEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(CreatureSpawnEvent.class, CreatureSpawnEvent.SpawnReason.class, new Getter<CreatureSpawnEvent.SpawnReason, CreatureSpawnEvent>(){

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable CreatureSpawnEvent.SpawnReason get(CreatureSpawnEvent e) {
                return e.getSpawnReason();
            }
        }, 0);
        EventValues.registerEventValue(FireworkExplodeEvent.class, Firework.class, new Getter<Firework, FireworkExplodeEvent>(){

            @Override
            public @Nullable Firework get(FireworkExplodeEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(FireworkExplodeEvent.class, FireworkEffect.class, new Getter<FireworkEffect, FireworkExplodeEvent>(){

            @Override
            public @Nullable FireworkEffect get(FireworkExplodeEvent e) {
                List effects = e.getEntity().getFireworkMeta().getEffects();
                if (effects.size() == 0) {
                    return null;
                }
                return (FireworkEffect)effects.get(0);
            }
        }, 0);
        EventValues.registerEventValue(PlayerRiptideEvent.class, ItemStack.class, new Getter<ItemStack, PlayerRiptideEvent>(){

            @Override
            public ItemStack get(PlayerRiptideEvent e) {
                return e.getItem();
            }
        }, 0);
        if (Skript.classExists("com.destroystokyo.paper.event.player.PlayerArmorChangeEvent")) {
            EventValues.registerEventValue(PlayerArmorChangeEvent.class, ItemStack.class, new Getter<ItemStack, PlayerArmorChangeEvent>(){

                @Override
                public @Nullable ItemStack get(PlayerArmorChangeEvent e) {
                    return e.getNewItem();
                }
            }, 0);
        }
        if (Skript.classExists("io.papermc.paper.event.player.PlayerInventorySlotChangeEvent")) {
            EventValues.registerEventValue(PlayerInventorySlotChangeEvent.class, ItemStack.class, new Getter<ItemStack, PlayerInventorySlotChangeEvent>(){

                @Override
                public @Nullable ItemStack get(PlayerInventorySlotChangeEvent event) {
                    return event.getNewItemStack();
                }
            }, 0);
            EventValues.registerEventValue(PlayerInventorySlotChangeEvent.class, ItemStack.class, new Getter<ItemStack, PlayerInventorySlotChangeEvent>(){

                @Override
                public @Nullable ItemStack get(PlayerInventorySlotChangeEvent event) {
                    return event.getOldItemStack();
                }
            }, -1);
            EventValues.registerEventValue(PlayerInventorySlotChangeEvent.class, Slot.class, new Getter<Slot, PlayerInventorySlotChangeEvent>(){

                @Override
                public @Nullable Slot get(PlayerInventorySlotChangeEvent event) {
                    PlayerInventory inv = event.getPlayer().getInventory();
                    int slotIndex = event.getSlot();
                    if (slotIndex >= 36) {
                        return new EquipmentSlot((HumanEntity)event.getPlayer(), slotIndex);
                    }
                    return new InventorySlot((Inventory)inv, slotIndex);
                }
            }, 0);
        }
        EventValues.registerEventValue(PrepareItemEnchantEvent.class, Player.class, new Getter<Player, PrepareItemEnchantEvent>(){

            @Override
            public @Nullable Player get(PrepareItemEnchantEvent e) {
                return e.getEnchanter();
            }
        }, 0);
        EventValues.registerEventValue(PrepareItemEnchantEvent.class, ItemStack.class, new Getter<ItemStack, PrepareItemEnchantEvent>(){

            @Override
            public @Nullable ItemStack get(PrepareItemEnchantEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(PrepareItemEnchantEvent.class, Block.class, new Getter<Block, PrepareItemEnchantEvent>(){

            @Override
            public @Nullable Block get(PrepareItemEnchantEvent e) {
                return e.getEnchantBlock();
            }
        }, 0);
        EventValues.registerEventValue(EnchantItemEvent.class, Player.class, new Getter<Player, EnchantItemEvent>(){

            @Override
            public @Nullable Player get(EnchantItemEvent e) {
                return e.getEnchanter();
            }
        }, 0);
        EventValues.registerEventValue(EnchantItemEvent.class, ItemStack.class, new Getter<ItemStack, EnchantItemEvent>(){

            @Override
            public @Nullable ItemStack get(EnchantItemEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(EnchantItemEvent.class, EnchantmentType[].class, new Getter<EnchantmentType[], EnchantItemEvent>(){

            @Override
            public @Nullable EnchantmentType[] get(EnchantItemEvent event) {
                return (EnchantmentType[])event.getEnchantsToAdd().entrySet().stream().map(entry -> new EnchantmentType((Enchantment)entry.getKey(), (Integer)entry.getValue())).toArray(EnchantmentType[]::new);
            }
        }, 0);
        EventValues.registerEventValue(EnchantItemEvent.class, Block.class, new Getter<Block, EnchantItemEvent>(){

            @Override
            public @Nullable Block get(EnchantItemEvent e) {
                return e.getEnchantBlock();
            }
        }, 0);
        EventValues.registerEventValue(HorseJumpEvent.class, Entity.class, new Getter<Entity, HorseJumpEvent>(){

            @Override
            public @Nullable Entity get(HorseJumpEvent evt) {
                return evt.getEntity();
            }
        }, 0);
        if (Skript.classExists("io.papermc.paper.event.player.PlayerTradeEvent")) {
            EventValues.registerEventValue(PlayerTradeEvent.class, AbstractVillager.class, new Getter<AbstractVillager, PlayerTradeEvent>(){

                @Override
                public @Nullable AbstractVillager get(PlayerTradeEvent event) {
                    return event.getVillager();
                }
            }, 0);
        }
        EventValues.registerEventValue(PlayerChangedWorldEvent.class, World.class, new Getter<World, PlayerChangedWorldEvent>(){

            @Override
            public @Nullable World get(PlayerChangedWorldEvent e) {
                return e.getFrom();
            }
        }, -1);
        EventValues.registerEventValue(PlayerEggThrowEvent.class, Egg.class, new Getter<Egg, PlayerEggThrowEvent>(){

            @Override
            public @Nullable Egg get(PlayerEggThrowEvent event) {
                return event.getEgg();
            }
        }, 0);
        if (Skript.classExists("io.papermc.paper.event.player.PlayerStopUsingItemEvent")) {
            EventValues.registerEventValue(PlayerStopUsingItemEvent.class, Timespan.class, new Getter<Timespan, PlayerStopUsingItemEvent>(){

                @Override
                public Timespan get(PlayerStopUsingItemEvent event) {
                    return Timespan.fromTicks(event.getTicksHeldFor());
                }
            }, 0);
            EventValues.registerEventValue(PlayerStopUsingItemEvent.class, ItemType.class, new Getter<ItemType, PlayerStopUsingItemEvent>(){

                @Override
                public ItemType get(PlayerStopUsingItemEvent event) {
                    return new ItemType(event.getItem());
                }
            }, 0);
        }
        if (Skript.classExists("org.bukkit.event.world.LootGenerateEvent")) {
            EventValues.registerEventValue(LootGenerateEvent.class, Entity.class, new Getter<Entity, LootGenerateEvent>(){

                @Override
                public @Nullable Entity get(LootGenerateEvent event) {
                    return event.getEntity();
                }
            }, 0);
            EventValues.registerEventValue(LootGenerateEvent.class, Location.class, new Getter<Location, LootGenerateEvent>(){

                @Override
                public @Nullable Location get(LootGenerateEvent event) {
                    return event.getLootContext().getLocation();
                }
            }, 0);
        }
        EventValues.registerEventValue(EntityResurrectEvent.class, Slot.class, new Getter<Slot, EntityResurrectEvent>(){

            @Override
            public @Nullable Slot get(EntityResurrectEvent event) {
                org.bukkit.inventory.EquipmentSlot hand = event.getHand();
                EntityEquipment equipment = event.getEntity().getEquipment();
                if (equipment == null || hand == null) {
                    return null;
                }
                return new EquipmentSlot(equipment, hand == org.bukkit.inventory.EquipmentSlot.HAND ? EquipmentSlot.EquipSlot.TOOL : EquipmentSlot.EquipSlot.OFF_HAND);
            }
        }, 0);
        EventValues.registerEventValue(PlayerItemHeldEvent.class, Slot.class, new Getter<Slot, PlayerItemHeldEvent>(){

            @Override
            public @Nullable Slot get(PlayerItemHeldEvent event) {
                return new InventorySlot((Inventory)event.getPlayer().getInventory(), event.getNewSlot());
            }
        }, 0);
        EventValues.registerEventValue(PlayerItemHeldEvent.class, Slot.class, new Getter<Slot, PlayerItemHeldEvent>(){

            @Override
            public @Nullable Slot get(PlayerItemHeldEvent event) {
                return new InventorySlot((Inventory)event.getPlayer().getInventory(), event.getPreviousSlot());
            }
        }, -1);
        if (Skript.isRunningMinecraft(1, 14)) {
            EventValues.registerEventValue(PlayerPickupArrowEvent.class, Projectile.class, new Getter<Projectile, PlayerPickupArrowEvent>(){

                @Override
                public Projectile get(PlayerPickupArrowEvent event) {
                    return event.getArrow();
                }
            }, 0);
        }
        EventValues.registerEventValue(PlayerPickupArrowEvent.class, ItemStack.class, new Getter<ItemStack, PlayerPickupArrowEvent>(){

            @Override
            public @Nullable ItemStack get(PlayerPickupArrowEvent event) {
                return event.getItem().getItemStack();
            }
        }, 0);
        if (Skript.classExists("org.bukkit.event.player.PlayerQuitEvent$QuitReason")) {
            EventValues.registerEventValue(PlayerQuitEvent.class, PlayerQuitEvent.QuitReason.class, new Getter<PlayerQuitEvent.QuitReason, PlayerQuitEvent>(){

                @Override
                public // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable PlayerQuitEvent.QuitReason get(PlayerQuitEvent event) {
                    return event.getReason();
                }
            }, 0);
        }
        if (Skript.classExists("io.papermc.paper.event.player.PlayerStonecutterRecipeSelectEvent")) {
            EventValues.registerEventValue(PlayerStonecutterRecipeSelectEvent.class, ItemStack.class, new Getter<ItemStack, PlayerStonecutterRecipeSelectEvent>(){

                @Override
                public ItemStack get(PlayerStonecutterRecipeSelectEvent event) {
                    return event.getStonecuttingRecipe().getResult();
                }
            }, 0);
        }
        EventValues.registerEventValue(EntityTransformEvent.class, Entity[].class, new Getter<Entity[], EntityTransformEvent>(){

            @Override
            public @Nullable Entity[] get(EntityTransformEvent event) {
                return (Entity[])event.getTransformedEntities().stream().toArray(Entity[]::new);
            }
        }, 0);
        EventValues.registerEventValue(EntityTransformEvent.class, EntityTransformEvent.TransformReason.class, new Getter<EntityTransformEvent.TransformReason, EntityTransformEvent>(){

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable EntityTransformEvent.TransformReason get(EntityTransformEvent event) {
                return event.getTransformReason();
            }
        }, 0);
    }
}

