/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.LivingEntity;

@Name(value="Can Pick Up Items")
@Description(value={"Whether living entities are able to pick up items off the ground or not."})
@Examples(value={"if player can pick items up:", "\tsend \"You can pick up items!\" to player", "", "on drop:", "\tif player can't pick\tup items:", "\t\tsend \"Be careful, you won't be able to pick that up!\" to player"})
@Since(value="2.8.0")
public class CondCanPickUpItems
extends PropertyCondition<LivingEntity> {
    @Override
    public boolean check(LivingEntity livingEntity) {
        return livingEntity.getCanPickupItems();
    }

    @Override
    protected PropertyCondition.PropertyType getPropertyType() {
        return PropertyCondition.PropertyType.CAN;
    }

    @Override
    protected String getPropertyName() {
        return "pick up items";
    }

    static {
        CondCanPickUpItems.register(CondCanPickUpItems.class, PropertyCondition.PropertyType.CAN, "pick([ ]up items| items up)", "livingentities");
    }
}

