/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Has Item Cooldown")
@Description(value={"Check whether a cooldown is active on the specified material for a specific player."})
@Examples(value={"if player has player's tool on cooldown:", "\tsend \"You can't use this item right now. Wait %item cooldown of player's tool for player%\""})
@Since(value="2.8.0")
public class CondHasItemCooldown
extends Condition {
    private Expression<Player> players;
    private Expression<ItemType> itemtypes;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.itemtypes = exprs[1];
        this.setNegated(matchedPattern > 1);
        return true;
    }

    @Override
    public boolean check(Event event) {
        return this.players.check(event, player -> this.itemtypes.check(event, itemType -> itemType.hasType() && player.hasCooldown(itemType.getMaterial())));
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.HAVE, event, debug, this.players, this.itemtypes.toString(event, debug) + " on cooldown");
    }

    static {
        Skript.registerCondition(CondHasItemCooldown.class, "%players% (has|have) [([an] item|a)] cooldown (on|for) %itemtypes%", "%players% (has|have) %itemtypes% on [(item|a)] cooldown", "%players% (doesn't|does not|do not|don't) have [([an] item|a)] cooldown (on|for) %itemtypes%", "%players% (doesn't|does not|do not|don't) have %itemtypes% on [(item|a)] cooldown");
    }
}

