/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Riding")
@Description(value={"Tests whether an entity is riding another or is in a vehicle."})
@Examples(value={"player is riding a saddled pig"})
@Since(value="2.0")
public class CondIsRiding
extends Condition {
    private Expression<Entity> entities;
    private Expression<EntityData<?>> types;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.types = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.entities.check(e, entity -> this.types.check(e, data -> data.isInstance(entity.getVehicle())), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.BE, e, debug, this.entities, "riding " + this.types.toString(e, debug));
    }

    static {
        PropertyCondition.register(CondIsRiding.class, "riding [%entitydatas%]", "entities");
    }
}

