/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import org.bukkit.inventory.meta.ItemMeta;

@Name(value="Is Unbreakable")
@Description(value={"Checks whether an item is unbreakable."})
@Examples(value={"if event-item is unbreakable"})
@Since(value="2.5.1")
@RequiredPlugins(value={"Minecraft 1.11+"})
public class CondIsUnbreakable
extends PropertyCondition<ItemType> {
    @Override
    public boolean check(ItemType item) {
        return item.getItemMeta().isUnbreakable();
    }

    @Override
    protected String getPropertyName() {
        return "unbreakable";
    }

    static {
        if (Skript.methodExists(ItemMeta.class, "isUnbreakable", new Class[0])) {
            CondIsUnbreakable.register(CondIsUnbreakable.class, "unbreakable", "itemtypes");
        }
    }
}

