/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.util.Kleenean;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Action Bar")
@Description(value={"Sends an action bar message to the given player(s)."})
@Examples(value={"send action bar \"Hello player!\" to player"})
@Since(value="2.3")
public class EffActionBar
extends Effect {
    private Expression<String> message;
    private Expression<Player> recipients;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.message = exprs[0];
        this.recipients = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event event) {
        String msg = this.message.getSingle(event);
        if (msg == null) {
            return;
        }
        BaseComponent[] components = BungeeConverter.convert(ChatMessages.parseToArray(msg));
        for (Player player : this.recipients.getArray(event)) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "send action bar " + this.message.toString(event, debug) + " to " + this.recipients.toString(event, debug);
    }

    static {
        Skript.registerEffect(EffActionBar.class, "send [the] action[ ]bar [with text] %string% [to %players%]");
    }
}

