/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Enchant/Disenchant")
@Description(value={"Enchant or disenchant an existing item."})
@Examples(value={"enchant the player's tool with sharpness 5", "disenchant the player's tool"})
@Since(value="2.0")
public class EffEnchant
extends Effect {
    private Expression<ItemType> items;
    private @Nullable Expression<EnchantmentType> enchantments;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        if (!Changer.ChangerUtils.acceptsChange(this.items, Changer.ChangeMode.SET, ItemStack.class)) {
            Skript.error(this.items + " cannot be changed, thus it cannot be (dis)enchanted");
            return false;
        }
        if (matchedPattern == 0) {
            this.enchantments = exprs[1];
        }
        return true;
    }

    @Override
    protected void execute(Event event) {
        ItemType[] items = this.items.getArray(event);
        if (items.length == 0) {
            return;
        }
        if (this.enchantments != null) {
            EnchantmentType[] types = this.enchantments.getArray(event);
            if (types.length == 0) {
                return;
            }
            for (ItemType item : items) {
                for (EnchantmentType type : types) {
                    Enchantment enchantment = type.getType();
                    assert (enchantment != null);
                    item.addEnchantments(new EnchantmentType(enchantment, type.getLevel()));
                }
            }
        } else {
            for (ItemType item : items) {
                item.clearEnchantments();
            }
        }
        this.items.change(event, (Object[])items.clone(), Changer.ChangeMode.SET);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return this.enchantments == null ? "disenchant " + this.items.toString(event, debug) : "enchant " + this.items.toString(event, debug) + " with " + this.enchantments;
    }

    static {
        Skript.registerEffect(EffEnchant.class, "enchant %~itemtypes% with %enchantmenttypes%", "disenchant %~itemtypes%");
    }
}

