/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.HealthUtils;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Damage/Heal/Repair")
@Description(value={"Damage/Heal/Repair an entity, or item."})
@Examples(value={"damage player by 5 hearts", "heal the player", "repair tool of player"})
@Since(value="1.0")
public class EffHealth
extends Effect {
    private Expression<?> damageables;
    private @Nullable Expression<Number> damage;
    private boolean heal = false;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (matchedPattern == 0 && exprs[2] != null) {
            Skript.warning("The fake damage cause extension of this effect has no functionality, and will be removed in the future");
        }
        this.damageables = exprs[0];
        if (!LivingEntity.class.isAssignableFrom(this.damageables.getReturnType()) && !Changer.ChangerUtils.acceptsChange(this.damageables, Changer.ChangeMode.SET, ItemType.class)) {
            Skript.error(this.damageables + " cannot be changed, thus it cannot be damaged or repaired.");
            return false;
        }
        this.damage = exprs[1];
        this.heal = matchedPattern >= 1;
        return true;
    }

    @Override
    public void execute(Event e) {
        double damage = 0.0;
        if (this.damage != null) {
            Number number = this.damage.getSingle(e);
            if (number == null) {
                return;
            }
            damage = number.doubleValue();
        }
        ?[] array = this.damageables.getArray(e);
        Object[] newArray = new Object[array.length];
        boolean requiresChange = false;
        for (int i = 0; i < array.length; ++i) {
            Object value = array[i];
            if (value instanceof ItemType) {
                ItemType itemType = (ItemType)value;
                ItemStack itemStack = itemType.getRandom();
                if (this.damage == null) {
                    ItemUtils.setDamage(itemStack, 0);
                } else {
                    ItemUtils.setDamage(itemStack, (int)Math2.fit(0.0, (double)ItemUtils.getDamage(itemStack) + (this.heal ? -damage : damage), (double)itemStack.getType().getMaxDurability()));
                }
                newArray[i] = new ItemType(itemStack);
                requiresChange = true;
                continue;
            }
            LivingEntity livingEntity = (LivingEntity)value;
            if (!this.heal) {
                HealthUtils.damage((Damageable)livingEntity, damage);
            } else if (this.damage == null) {
                HealthUtils.setHealth((Damageable)livingEntity, HealthUtils.getMaxHealth((Damageable)livingEntity));
            } else {
                HealthUtils.heal((Damageable)livingEntity, damage);
            }
            newArray[i] = livingEntity;
        }
        if (requiresChange) {
            this.damageables.change(e, newArray, Changer.ChangeMode.SET);
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.heal ? "heal" : "damage") + " " + this.damageables.toString(e, debug) + (this.damage != null ? " by " + this.damage.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffHealth.class, "damage %livingentities/itemtypes% by %number% [heart[s]] [with fake cause %-damagecause%]", "heal %livingentities% [by %-number% [heart[s]]]", "repair %itemtypes% [by %-number%]");
    }
}

