/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Play Sound")
@Description(value={"Plays a sound at given location for everyone or just for given players, or plays a sound to specified players. Both Minecraft sound names and <a href=\"https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Sound.html\">Spigot sound names</a> are supported. Playing resource pack sounds are supported too. The sound category is 'master' by default. ", "", "Please note that sound names can get changed in any Minecraft or Spigot version, or even removed from Minecraft itself."})
@Examples(value={"play sound \"block.note_block.pling\" # It is block.note.pling in 1.12.2", "play sound \"entity.experience_orb.pickup\" with volume 0.5 to the player", "play sound \"custom.music.1\" in jukebox category at {speakerBlock}"})
@Since(value="2.2-dev28, 2.4 (sound categories)")
public class EffPlaySound
extends Effect {
    private static final Pattern KEY_PATTERN = Pattern.compile("([a-z0-9._-]+:)?[a-z0-9/._-]+");
    private Expression<String> sounds;
    @Nullable
    private Expression<SoundCategory> category;
    @Nullable
    private Expression<Number> volume;
    @Nullable
    private Expression<Number> pitch;
    @Nullable
    private Expression<Location> locations;
    @Nullable
    private Expression<Player> players;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sounds = exprs[0];
        this.category = exprs[1];
        this.volume = exprs[2];
        this.pitch = exprs[3];
        if (matchedPattern == 0) {
            this.locations = exprs[4];
            this.players = exprs[5];
        } else {
            this.players = exprs[4];
            this.locations = exprs[5];
        }
        return true;
    }

    @Override
    protected void execute(Event event) {
        block7: {
            float pitch;
            float volume;
            SoundCategory category;
            block6: {
                category = this.category == null ? SoundCategory.MASTER : this.category.getOptionalSingle(event).orElse(SoundCategory.MASTER);
                volume = this.volume == null ? 1.0f : this.volume.getOptionalSingle(event).orElse(1).floatValue();
                float f = pitch = this.pitch == null ? 1.0f : this.pitch.getOptionalSingle(event).orElse(1).floatValue();
                if (this.players == null) break block6;
                if (this.locations == null) {
                    for (Player player : this.players.getArray(event)) {
                        SoundReceiver.play(Player::playSound, Player::playSound, player, player.getLocation(), this.sounds.getArray(event), category, volume, pitch);
                    }
                } else {
                    for (Player player : this.players.getArray(event)) {
                        for (Location location : this.locations.getArray(event)) {
                            SoundReceiver.play(Player::playSound, Player::playSound, player, location, this.sounds.getArray(event), category, volume, pitch);
                        }
                    }
                }
                break block7;
            }
            if (this.locations == null) break block7;
            for (Location location : this.locations.getArray(event)) {
                SoundReceiver.play(World::playSound, World::playSound, location.getWorld(), location, this.sounds.getArray(event), category, volume, pitch);
            }
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        StringBuilder builder = new StringBuilder().append("play sound ").append(this.sounds.toString(event, debug));
        if (this.category != null) {
            builder.append(" in ").append(this.category.toString(event, debug));
        }
        if (this.volume != null) {
            builder.append(" with volume ").append(this.volume.toString(event, debug));
        }
        if (this.pitch != null) {
            builder.append(" with pitch ").append(this.pitch.toString(event, debug));
        }
        if (this.locations != null) {
            builder.append(" at ").append(this.locations.toString(event, debug));
        }
        if (this.players != null) {
            builder.append(" to ").append(this.players.toString(event, debug));
        }
        return builder.toString();
    }

    static {
        Skript.registerEffect(EffPlaySound.class, "play sound[s] %strings% [(in|from) %-soundcategory%] [(at|with) volume %-number%] [(and|at|with) pitch %-number%] at %locations% [(to|for) %-players%]", "play sound[s] %strings% [(in|from) %-soundcategory%] [(at|with) volume %-number%] [(and|at|with) pitch %-number%] [(to|for) %players%] [(at|from) %-locations%]");
    }

    @FunctionalInterface
    private static interface SoundReceiver<T, S> {
        public void play(@NotNull T var1, @NotNull Location var2, @NotNull S var3, @NotNull SoundCategory var4, float var5, float var6);

        public static <T> void play(@NotNull SoundReceiver<T, String> stringReceiver, @NotNull SoundReceiver<T, Sound> soundReceiver, @NotNull T receiver, @NotNull Location location, @NotNull String[] sounds, @NotNull SoundCategory category, float volume, float pitch) {
            for (String sound : sounds) {
                try {
                    Sound enumSound = Sound.valueOf((String)sound.toUpperCase(Locale.ENGLISH));
                    soundReceiver.play(receiver, location, enumSound, category, volume, pitch);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    sound = sound.toLowerCase(Locale.ENGLISH);
                    if (!KEY_PATTERN.matcher(sound).matches()) continue;
                    stringReceiver.play(receiver, location, sound, category, volume, pitch);
                }
            }
        }
    }
}

