/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.util.Map;
import java.util.regex.Matcher;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Replace")
@Description(value={"Replaces all occurrences of a given text with another text. Please note that you can only change variables and a few expressions, e.g. a <a href='./expressions.html#ExprMessage'>message</a> or a line of a sign."})
@Examples(value={"replace \"<item>\" in {textvar} with \"%item%\"", "replace every \"&\" with \"\u00a7\" in line 1", "# The following acts as a simple chat censor, but it will e.g. censor mass, hassle, assassin, etc. as well:", "on chat:", "\treplace all \"kys\", \"idiot\" and \"noob\" with \"****\" in the message", " ", "replace all stone and dirt in player's inventory and player's top inventory with diamond"})
@Since(value="2.0, 2.2-dev24 (replace in multiple strings and replace items in inventory), 2.5 (replace first, case sensitivity)")
public class EffReplace
extends Effect {
    private Expression<?> haystack;
    private Expression<?> needles;
    private Expression<?> replacement;
    private boolean replaceString = true;
    private boolean replaceFirst = false;
    private boolean caseSensitive = false;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.haystack = exprs[1 + matchedPattern % 2];
        this.replaceString = matchedPattern < 4;
        boolean bl = this.replaceFirst = matchedPattern > 1 && matchedPattern < 4;
        if (this.replaceString && !Changer.ChangerUtils.acceptsChange(this.haystack, Changer.ChangeMode.SET, String.class)) {
            Skript.error(this.haystack + " cannot be changed and can thus not have parts replaced.");
            return false;
        }
        if (SkriptConfig.caseSensitive.value().booleanValue() || parseResult.mark == 1) {
            this.caseSensitive = true;
        }
        this.needles = exprs[0];
        this.replacement = exprs[2 - matchedPattern % 2];
        return true;
    }

    @Override
    protected void execute(Event event) {
        Object[] needles = this.needles.getAll(event);
        if (this.haystack instanceof ExpressionList) {
            for (Expression haystackExpr : ((ExpressionList)this.haystack).getExpressions()) {
                this.replace(event, needles, haystackExpr);
            }
        } else {
            this.replace(event, needles, this.haystack);
        }
    }

    private void replace(Event event, Object[] needles, Expression<?> haystackExpr) {
        Object[] haystack = haystackExpr.getAll(event);
        Object replacement = this.replacement.getSingle(event);
        if (replacement == null || haystack == null || haystack.length == 0 || needles == null || needles.length == 0) {
            return;
        }
        if (this.replaceString) {
            if (this.replaceFirst) {
                for (int x = 0; x < haystack.length; ++x) {
                    for (Object n : needles) {
                        assert (n != null);
                        haystack[x] = StringUtils.replaceFirst((String)haystack[x], (String)n, Matcher.quoteReplacement((String)replacement), this.caseSensitive);
                    }
                }
            } else {
                for (int x = 0; x < haystack.length; ++x) {
                    for (Object n : needles) {
                        assert (n != null);
                        haystack[x] = StringUtils.replace((String)haystack[x], (String)n, (String)replacement, this.caseSensitive);
                    }
                }
            }
            haystackExpr.change(event, haystack, Changer.ChangeMode.SET);
        } else {
            for (Inventory inv : (Inventory[])haystack) {
                for (ItemType needle : (ItemType[])needles) {
                    for (Map.Entry entry : inv.all(needle.getMaterial()).entrySet()) {
                        int slot = (Integer)entry.getKey();
                        ItemStack itemStack = (ItemStack)entry.getValue();
                        if (!new ItemType(itemStack).isSimilar(needle)) continue;
                        ItemStack newItemStack = ((ItemType)replacement).getRandom();
                        newItemStack.setAmount(itemStack.getAmount());
                        inv.setItem(slot, newItemStack);
                    }
                }
            }
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (this.replaceFirst) {
            return "replace first " + this.needles.toString(event, debug) + " in " + this.haystack.toString(event, debug) + " with " + this.replacement.toString(event, debug) + "(case sensitive: " + this.caseSensitive + ")";
        }
        return "replace " + this.needles.toString(event, debug) + " in " + this.haystack.toString(event, debug) + " with " + this.replacement.toString(event, debug) + "(case sensitive: " + this.caseSensitive + ")";
    }

    static {
        Skript.registerEffect(EffReplace.class, "replace (all|every|) %strings% in %strings% with %string% [(1\u00a6with case sensitivity)]", "replace (all|every|) %strings% with %string% in %strings% [(1\u00a6with case sensitivity)]", "replace first %strings% in %strings% with %string% [(1\u00a6with case sensitivity)]", "replace first %strings% with %string% in %string% [(1\u00a6with case sensitivity)]", "replace (all|every|) %itemtypes% in %inventories% with %itemtype%", "replace (all|every|) %itemtypes% with %itemtype% in %inventories%");
    }
}

