/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Rotate Around Vector")
@Description(value={"Rotates one or more vectors around another vector"})
@Examples(value={"rotate {_v} around vector 1, 0, 0 by 90"})
@Since(value="2.2-dev28")
public class EffVectorRotateAroundAnother
extends Effect {
    private Expression<Vector> vectors;
    private Expression<Vector> axis;
    private Expression<Number> degree;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vectors = exprs[0];
        this.axis = exprs[1];
        this.degree = exprs[2];
        return true;
    }

    @Override
    protected void execute(Event event) {
        Vector axis = this.axis.getSingle(event);
        Number angle = this.degree.getSingle(event);
        if (axis == null || angle == null) {
            return;
        }
        for (Vector vector : this.vectors.getArray(event)) {
            VectorMath.rot(vector, axis, angle.doubleValue());
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "rotate " + this.vectors.toString(event, debug) + " around " + this.axis.toString(event, debug) + " by " + this.degree.toString(event, debug) + "degrees";
    }

    static {
        Skript.registerEffect(EffVectorRotateAroundAnother.class, "rotate %vectors% around %vector% by %number% [degrees]");
    }
}

