/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Llama;
import org.bukkit.entity.TraderLlama;
import org.eclipse.jdt.annotation.Nullable;

public class LlamaData
extends EntityData<Llama> {
    private static final boolean TRADER_SUPPORT = Skript.classExists("org.bukkit.entity.TraderLlama");
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Llama.Color color = null;
    private boolean isTrader;

    public LlamaData() {
    }

    public LlamaData(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Llama.Color color, boolean isTrader) {
        this.color = color;
        this.isTrader = isTrader;
        this.matchedPattern = (color != null ? color.ordinal() + 1 : 0) + (isTrader ? 5 : 0);
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        boolean bl = this.isTrader = TRADER_SUPPORT && matchedPattern > 4;
        if (TRADER_SUPPORT && matchedPattern > 5) {
            this.color = Llama.Color.values()[matchedPattern - 6];
        } else if (matchedPattern > 0 && matchedPattern < 5) {
            this.color = Llama.Color.values()[matchedPattern - 1];
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Llama> c, @Nullable Llama llama) {
        if (TRADER_SUPPORT && c != null) {
            this.isTrader = c.isAssignableFrom(TraderLlama.class);
        }
        if (llama != null) {
            this.color = llama.getColor();
            this.isTrader = TRADER_SUPPORT && llama instanceof TraderLlama;
        }
        return true;
    }

    @Override
    public void set(Llama entity) {
        Llama.Color randomColor;
        Llama.Color color = randomColor = this.color == null ? CollectionUtils.getRandom(Llama.Color.values()) : this.color;
        assert (randomColor != null);
        entity.setColor(randomColor);
    }

    @Override
    protected boolean match(Llama entity) {
        return TRADER_SUPPORT && this.isTrader == entity instanceof TraderLlama && (this.color == null || this.color == entity.getColor()) || this.color == null || this.color == entity.getColor();
    }

    @Override
    public Class<? extends Llama> getType() {
        if (TRADER_SUPPORT) {
            return this.isTrader ? TraderLlama.class : Llama.class;
        }
        assert (!this.isTrader);
        return Llama.class;
    }

    @Override
    public EntityData getSuperType() {
        return new LlamaData(this.color, this.isTrader);
    }

    @Override
    protected int hashCode_i() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.isTrader ? 1 : 0);
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> data) {
        if (!(data instanceof LlamaData)) {
            return false;
        }
        LlamaData d = (LlamaData)data;
        return this.isTrader == d.isTrader && d.color == this.color;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> data) {
        if (!(data instanceof LlamaData)) {
            return false;
        }
        LlamaData d = (LlamaData)data;
        return this.isTrader == d.isTrader && (this.color == null || d.color == this.color);
    }

    static {
        if (TRADER_SUPPORT) {
            EntityData.register(LlamaData.class, "llama", Llama.class, 0, "llama", "creamy llama", "white llama", "brown llama", "gray llama", "trader llama", "creamy trader llama", "white trader llama", "brown trader llama", "gray trader llama");
        } else if (Skript.classExists("org.bukkit.entity.Llama")) {
            EntityData.register(LlamaData.class, "llama", Llama.class, 0, "llama", "creamy llama", "white llama", "brown llama", "gray llama");
        }
    }
}

