/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import org.bukkit.DyeColor;
import org.bukkit.entity.Wolf;
import org.eclipse.jdt.annotation.Nullable;

public class WolfData
extends EntityData<Wolf> {
    private @Nullable DyeColor collarColor;
    private int angry = 0;
    private int tamed = 0;

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern <= 2) {
            this.angry = matchedPattern - 1;
        } else {
            int n = this.tamed = matchedPattern == 3 ? -1 : 1;
        }
        if (exprs[0] != null) {
            this.collarColor = ((Color)exprs[0].getSingle()).asDyeColor();
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Wolf> c, @Nullable Wolf wolf) {
        if (wolf != null) {
            this.angry = wolf.isAngry() ? 1 : -1;
            this.tamed = wolf.isTamed() ? 1 : -1;
            this.collarColor = wolf.getCollarColor();
        }
        return true;
    }

    @Override
    public void set(Wolf entity) {
        if (this.angry != 0) {
            entity.setAngry(this.angry == 1);
        }
        if (this.tamed != 0) {
            entity.setTamed(this.tamed == 1);
        }
        if (this.collarColor != null) {
            entity.setCollarColor(this.collarColor);
        }
    }

    @Override
    public boolean match(Wolf entity) {
        return !(this.angry != 0 && entity.isAngry() != (this.angry == 1) || this.tamed != 0 && entity.isTamed() != (this.tamed == 1) || this.collarColor != null && entity.getCollarColor() != this.collarColor);
    }

    @Override
    public Class<Wolf> getType() {
        return Wolf.class;
    }

    @Override
    protected int hashCode_i() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.angry;
        result = prime * result + this.tamed;
        result = prime * result + (this.collarColor == null ? 0 : this.collarColor.hashCode());
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof WolfData)) {
            return false;
        }
        WolfData other = (WolfData)obj;
        if (this.angry != other.angry) {
            return false;
        }
        if (this.tamed != other.tamed) {
            return false;
        }
        return this.collarColor == other.collarColor;
    }

    @Override
    @Deprecated
    protected boolean deserialize(String s) {
        String[] split = s.split("\\|");
        if (split.length != 2) {
            return false;
        }
        try {
            this.angry = Integer.parseInt(split[0]);
            this.tamed = Integer.parseInt(split[1]);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (entityData instanceof WolfData) {
            WolfData wolfData = (WolfData)entityData;
            return !(this.angry != 0 && wolfData.angry != this.angry || this.tamed != 0 && wolfData.tamed != this.tamed || wolfData.collarColor != this.collarColor);
        }
        return false;
    }

    @Override
    public EntityData<Wolf> getSuperType() {
        return new WolfData();
    }

    static {
        EntityData.register(WolfData.class, "wolf", Wolf.class, 1, "peaceful wolf", "wolf", "angry wolf", "wild wolf", "tamed wolf");
    }
}

