/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.bukkit.ScheduledEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Time;
import ch.njol.util.Math2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class EvtAtTime
extends SkriptEvent
implements Comparable<EvtAtTime> {
    private static final int CHECK_PERIOD = 10;
    private static final Map<World, EvtAtInfo> TRIGGERS;
    private int tick;
    private World[] worlds;
    private static int taskID;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.tick = ((Time)args[0].getSingle()).getTicks();
        this.worlds = args[1] == null ? Bukkit.getWorlds().toArray(new World[0]) : (World[])args[1].getAll();
        return true;
    }

    @Override
    public boolean postLoad() {
        for (World world : this.worlds) {
            EvtAtInfo info = TRIGGERS.get(world);
            if (info == null) {
                info = new EvtAtInfo();
                TRIGGERS.put(world, info);
                info.lastTick = (int)world.getTime() - 1;
            }
            info.instances.add(this);
            Collections.sort(info.instances);
        }
        EvtAtTime.registerListener();
        return true;
    }

    @Override
    public void unload() {
        Iterator<EvtAtInfo> iterator = TRIGGERS.values().iterator();
        while (iterator.hasNext()) {
            EvtAtInfo info = iterator.next();
            info.instances.remove(this);
            if (info.currentIndex >= info.instances.size()) {
                info.currentIndex--;
            }
            if (!info.instances.isEmpty()) continue;
            iterator.remove();
        }
        if (taskID == -1 && TRIGGERS.isEmpty()) {
            Bukkit.getScheduler().cancelTask(taskID);
            taskID = -1;
        }
    }

    @Override
    public boolean check(Event event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEventPrioritySupported() {
        return false;
    }

    private static void registerListener() {
        if (taskID != -1) {
            return;
        }
        taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), () -> {
            for (Map.Entry<World, EvtAtInfo> entry : TRIGGERS.entrySet()) {
                boolean midnight;
                EvtAtInfo info = entry.getValue();
                int tick = (int)entry.getKey().getTime();
                if (info.lastTick == tick) continue;
                if (info.lastTick + 20 < tick || info.lastTick > tick && info.lastTick - 24000 + 20 < tick) {
                    info.lastTick = Math2.mod(tick - 10, 24000);
                }
                boolean bl = midnight = info.lastTick > tick;
                if (midnight) {
                    info.lastTick -= 24000;
                }
                int startIndex = info.currentIndex;
                do {
                    int nextTick;
                    EvtAtTime next = (EvtAtTime)info.instances.get(info.currentIndex);
                    int n = nextTick = midnight && next.tick > 12000 ? next.tick - 24000 : next.tick;
                    if (info.lastTick >= nextTick || nextTick > tick) break;
                    ScheduledEvent event = new ScheduledEvent(entry.getKey());
                    SkriptEventHandler.logEventStart(event);
                    SkriptEventHandler.logTriggerEnd(next.trigger);
                    next.trigger.execute(event);
                    SkriptEventHandler.logTriggerEnd(next.trigger);
                    SkriptEventHandler.logEventEnd();
                    info.currentIndex++;
                    if (info.currentIndex != info.instances.size()) continue;
                    info.currentIndex = 0;
                } while (info.currentIndex != startIndex);
                info.lastTick = tick;
            }
        }, 0L, 10L);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "at " + Time.toString(this.tick) + " in worlds " + Classes.toString(this.worlds, true);
    }

    @Override
    public int compareTo(@Nullable EvtAtTime event) {
        return event == null ? this.tick : this.tick - event.tick;
    }

    static {
        Skript.registerEvent("*At Time", EvtAtTime.class, ScheduledEvent.class, "at %time% [in %worlds%]").description("An event that occurs at a given <a href='./classes.html#time'>minecraft time</a> in every world or only in specific worlds.").examples("at 18:00", "at 7am in \"world\"").since("1.3.4");
        TRIGGERS = new ConcurrentHashMap<World, EvtAtInfo>();
        taskID = -1;
    }

    private static final class EvtAtInfo {
        private int lastTick;
        private int currentIndex;
        private final List<EvtAtTime> instances = new ArrayList<EvtAtTime>();

        private EvtAtInfo() {
        }
    }
}

