/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Respawn Anchor Charges")
@Description(value={"The charges of a respawn anchor."})
@Examples(value={"set the charges of event-block to 3"})
@RequiredPlugins(value={"Minecraft 1.16+"})
@Since(value="2.7")
public class ExprCharges
extends SimplePropertyExpression<Block, Integer> {
    private boolean maxCharges;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.maxCharges = parseResult.hasTag("max");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public @Nullable Integer convert(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof RespawnAnchor) {
            if (this.maxCharges) {
                return ((RespawnAnchor)blockData).getMaximumCharges();
            }
            return ((RespawnAnchor)blockData).getCharges();
        }
        return null;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case REMOVE: 
            case ADD: 
            case SET: 
            case RESET: 
            case DELETE: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int charge = 0;
        int charges = delta != null ? ((Number)delta[0]).intValue() : 0;
        for (Block block : (Block[])this.getExpr().getArray(event)) {
            if (!(block.getBlockData() instanceof RespawnAnchor)) continue;
            RespawnAnchor anchor = (RespawnAnchor)block.getBlockData();
            switch (mode) {
                case REMOVE: {
                    charge = anchor.getCharges() - charges;
                    break;
                }
                case ADD: {
                    charge = anchor.getCharges() + charges;
                    break;
                }
                case SET: {
                    charge = charges;
                }
            }
            anchor.setCharges(Math.min(Math.max(charge, 0), 4));
            block.setBlockData((BlockData)anchor);
        }
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    protected String getPropertyName() {
        return "charges";
    }

    static {
        if (Skript.classExists("org.bukkit.block.data.type.RespawnAnchor")) {
            ExprCharges.register(ExprCharges.class, Integer.class, "[:max[imum]] charge[s]", "blocks");
        }
    }
}

