/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.apache.commons.lang.StringUtils;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Chat Format")
@Description(value={"Can be used to get/retrieve the chat format. The sender of a message is represented by [player] or [sender], and the message by [message] or [msg]."})
@Examples(value={"set the chat format to \"&lt;yellow&gt;[player]&lt;light gray&gt;: &lt;green&gt;[message]\""})
@Since(value="2.2-dev31")
public class ExprChatFormat
extends SimpleExpression<String> {
    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{String.class};
        }
        return null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)AsyncPlayerChatEvent.class)) {
            Skript.error("The expression 'chat format' may only be used in chat events");
            return false;
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "chat format";
    }

    protected @Nullable String[] get(Event e) {
        if (!(e instanceof AsyncPlayerChatEvent)) {
            return null;
        }
        return new String[]{ExprChatFormat.convertToFriendly(((AsyncPlayerChatEvent)e).getFormat())};
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || !(e instanceof AsyncPlayerChatEvent)) {
            return;
        }
        String format = null;
        if (mode == Changer.ChangeMode.SET) {
            String newFormat = (String)delta[0];
            if (newFormat == null) {
                return;
            }
            format = ExprChatFormat.convertToNormal(newFormat);
        } else if (mode == Changer.ChangeMode.RESET) {
            format = "<%s> %s";
        }
        if (format == null) {
            return;
        }
        ((AsyncPlayerChatEvent)e).setFormat(format);
    }

    private static String convertToNormal(String format) {
        return format.replaceAll("%", "%%").replaceAll("(?i)\\[(player|sender)]", "%1\\$s").replaceAll("(?i)\\[(message|msg)]", "%2\\$s");
    }

    private static String convertToFriendly(String format) {
        if ((format = format.replaceAll("%%", "%").replaceAll("%1\\$s", "[player]").replaceAll("%2\\$s", "[message]")).contains("%s")) {
            if (StringUtils.countMatches((String)format, (String)"%s") >= 2) {
                format = format.replaceFirst("%s", "[player]");
                format = format.replaceFirst("%s", "[message]");
            } else {
                format = format.replaceFirst("%s", format.contains("[player]") || format.contains("%1$s") ? "[message]" : "[player]");
            }
        }
        return format;
    }

    static {
        Skript.registerExpression(ExprChatFormat.class, String.class, ExpressionType.SIMPLE, "[the] (message|chat) format[ting]");
    }
}

