/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Drops")
@Description(value={"Only works in death events. Holds the drops of the dying creature. Drops can be prevented by removing them with \"remove ... from drops\", e.g. \"remove all pickaxes from the drops\", or \"clear drops\" if you don't want any drops at all."})
@Examples(value={"clear drops", "remove 4 planks from the drops"})
@Since(value="1.0")
@Events(value={"death"})
public class ExprDrops
extends SimpleExpression<ItemType> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)EntityDeathEvent.class)) {
            Skript.error("The expression 'drops' can only be used in death events", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected @Nullable ItemType[] get(Event e) {
        if (!(e instanceof EntityDeathEvent)) {
            return null;
        }
        return (ItemType[])((EntityDeathEvent)e).getDrops().stream().map(ItemType::new).toArray(ItemType[]::new);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.getParser().getHasDelayBefore().isTrue()) {
            Skript.error("Can't change the drops after the event has already passed");
            return null;
        }
        switch (mode) {
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: 
            case SET: {
                return CollectionUtils.array(ItemType[].class, Inventory[].class, Experience[].class);
            }
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(event instanceof EntityDeathEvent)) {
            return;
        }
        List drops = ((EntityDeathEvent)event).getDrops();
        int originalExperience = ((EntityDeathEvent)event).getDroppedExp();
        assert (delta != null);
        int deltaExperience = -1;
        boolean removeAllExperience = false;
        ArrayList<ItemType> deltaDrops = new ArrayList<ItemType>();
        for (Object o : delta) {
            if (o instanceof Experience) {
                if (((Experience)o).getInternalXP() == -1 && mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL) {
                    removeAllExperience = true;
                }
                if (deltaExperience == -1) {
                    deltaExperience = ((Experience)o).getXP();
                    continue;
                }
                deltaExperience += ((Experience)o).getXP();
                continue;
            }
            if (o instanceof Inventory) {
                for (ItemStack item : ((Inventory)o).getContents()) {
                    if (item == null) continue;
                    deltaDrops.add(new ItemType(item));
                }
                continue;
            }
            if (o instanceof ItemType) {
                deltaDrops.add((ItemType)o);
                continue;
            }
            assert (false);
        }
        if (deltaExperience > -1) {
            switch (mode) {
                case SET: {
                    ((EntityDeathEvent)event).setDroppedExp(deltaExperience);
                    break;
                }
                case ADD: {
                    ((EntityDeathEvent)event).setDroppedExp(originalExperience + deltaExperience);
                    break;
                }
                case REMOVE: {
                    ((EntityDeathEvent)event).setDroppedExp(originalExperience - deltaExperience);
                }
                case REMOVE_ALL: {
                    if (!removeAllExperience) break;
                    ((EntityDeathEvent)event).setDroppedExp(0);
                    break;
                }
                case DELETE: 
                case RESET: {
                    assert (false);
                    break;
                }
            }
        }
        if (!deltaDrops.isEmpty()) {
            switch (mode) {
                case SET: {
                    drops.clear();
                }
                case ADD: {
                    for (ItemType item : deltaDrops) {
                        item.addTo(drops);
                    }
                    break;
                }
                case REMOVE: {
                    for (ItemType item : deltaDrops) {
                        item.removeFrom(false, drops);
                    }
                    break;
                }
                case REMOVE_ALL: {
                    for (ItemType item : deltaDrops) {
                        item.removeAll(false, drops);
                    }
                    break;
                }
                case DELETE: 
                case RESET: {
                    assert (false);
                    break;
                }
            }
        }
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "the drops";
    }

    static {
        Skript.registerExpression(ExprDrops.class, ItemType.class, ExpressionType.SIMPLE, "[the] drops");
    }
}

