/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Damage Value/Durability")
@Description(value={"The damage value/durability of an item."})
@Examples(value={"set damage value of player's tool to 10", "reset the durability of {_item}", "set durability of player's held item to 0"})
@Since(value="1.2, 2.7 (durability reversed)")
public class ExprDurability
extends SimplePropertyExpression<Object, Integer> {
    private boolean durability;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.durability = parseResult.mark == 1;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public @Nullable Integer convert(Object object) {
        ItemType itemType = ExprDurability.asItemType(object);
        if (itemType == null) {
            return null;
        }
        ItemMeta meta = itemType.getItemMeta();
        return meta instanceof Damageable ? this.convertToDamage(itemType.getMaterial(), ((Damageable)meta).getDamage()) : 0;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: 
            case DELETE: 
            case RESET: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int change;
        int n = change = delta == null ? 0 : ((Number)delta[0]).intValue();
        if (mode == Changer.ChangeMode.REMOVE) {
            change = -change;
        }
        for (Object object : this.getExpr().getArray(event)) {
            ItemMeta meta;
            ItemType itemType = ExprDurability.asItemType(object);
            if (itemType == null || !((meta = itemType.getItemMeta()) instanceof Damageable)) continue;
            Damageable damageable = (Damageable)meta;
            Material material = itemType.getMaterial();
            switch (mode) {
                case ADD: 
                case REMOVE: {
                    int current = this.convertToDamage(material, damageable.getDamage());
                    damageable.setDamage(this.convertToDamage(material, current + change));
                    break;
                }
                case SET: {
                    damageable.setDamage(this.convertToDamage(material, change));
                    break;
                }
                case DELETE: 
                case RESET: {
                    damageable.setDamage(0);
                }
            }
            itemType.setItemMeta(meta);
            if (!(object instanceof Slot)) continue;
            ((Slot)object).setItem(itemType.getRandom());
        }
    }

    private int convertToDamage(Material material, int value) {
        if (!this.durability) {
            return value;
        }
        short maxDurability = material.getMaxDurability();
        if (maxDurability == 0) {
            return 0;
        }
        return maxDurability - value;
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String getPropertyName() {
        return this.durability ? "durability" : "damage";
    }

    private static @Nullable ItemType asItemType(Object object) {
        if (object instanceof ItemType) {
            return (ItemType)object;
        }
        ItemStack itemStack = ((Slot)object).getItem();
        if (itemStack == null) {
            return null;
        }
        return new ItemType(itemStack);
    }

    static {
        ExprDurability.register(ExprDurability.class, Integer.class, "(damage[s] [value[s]]|1:durabilit(y|ies))", "itemtypes/slots");
    }
}

