/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hotbar Button")
@Description(value={"The hotbar button clicked in an <a href='events.html#inventory_click'>inventory click</a> event."})
@Examples(value={"on inventory click:", "\tsend \"You clicked the hotbar button %hotbar button%!\""})
@Since(value="2.5")
public class ExprHotbarButton
extends SimpleExpression<Long> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)InventoryClickEvent.class)) {
            Skript.error("The 'hotbar button' expression may only be used in an inventory click event.");
            return false;
        }
        return true;
    }

    protected @Nullable Long[] get(Event e) {
        if (e instanceof InventoryClickEvent) {
            return new Long[]{((InventoryClickEvent)e).getHotbarButton()};
        }
        return null;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the hotbar button";
    }

    static {
        Skript.registerExpression(ExprHotbarButton.class, Long.class, ExpressionType.SIMPLE, "[the] hotbar button");
    }
}

