/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import java.util.Map;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.comparator.Comparators;

@Name(value="Indices of List")
@Description(value={"Returns all the indices of a list variable, optionally sorted by their values.", "To sort the indices, all objects in the list must be comparable;", "Otherwise, this expression will just return the unsorted indices."})
@Examples(value={"set {l::*} to \"some\", \"cool\" and \"values\"", "broadcast \"%indices of {l::*}%\" # result is 1, 2 and 3", "", "set {_leader-board::first} to 17", "set {_leader-board::third} to 30", "set {_leader-board::second} to 25", "set {_leader-board::fourth} to 42", "set {_ascending-indices::*} to sorted indices of {_leader-board::*} in ascending order", "broadcast \"%{_ascending-indices::*}%\" #result is first, second, third, fourth", "set {_descending-indices::*} to sorted indices of {_leader-board::*} in descending order", "broadcast \"%{_descending-indices::*}%\" #result is fourth, third, second, first"})
@Since(value="2.4 (indices), 2.6.1 (sorting)")
public class ExprIndices
extends SimpleExpression<String> {
    private Variable<?> list;
    private boolean sort;
    private boolean descending;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sort = matchedPattern > 1;
        boolean bl = this.descending = parseResult.mark == 1;
        if (exprs[0] instanceof Variable && ((Variable)exprs[0]).isList()) {
            this.list = (Variable)exprs[0];
            return true;
        }
        if (LiteralUtils.canInitSafely(exprs[0])) {
            Skript.error("The indices expression may only be used with list variables");
        }
        return false;
    }

    protected @Nullable String[] get(Event e) {
        Map variable = (Map)this.list.getRaw(e);
        if (variable == null) {
            return null;
        }
        if (this.sort) {
            int direction = this.descending ? -1 : 1;
            return (String[])variable.entrySet().stream().sorted((a, b) -> this.compare((Map.Entry<String, Object>)a, (Map.Entry<String, Object>)b, direction)).map(Map.Entry::getKey).toArray(String[]::new);
        }
        return variable.keySet().toArray(new String[0]);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        String text = "indices of " + this.list.toString(e, debug);
        if (this.sort) {
            text = "sorted " + text + " in " + (this.descending ? "descending" : "ascending") + " order";
        }
        return text;
    }

    private int compare(Map.Entry<String, Object> a, Map.Entry<String, Object> b, int direction) {
        return Comparators.compare(a.getValue(), b.getValue()).getRelation() * direction;
    }

    static {
        Skript.registerExpression(ExprIndices.class, String.class, ExpressionType.COMBINED, "[(the|all [[of] the])] (indexes|indices) of %~objects%", "%~objects%'[s] (indexes|indices)", "[sorted] (indices|indexes) of %~objects% in (ascending|1\u00a6descending) order", "[sorted] %~objects%'[s] (indices|indexes) in (ascending|1\u00a6descending) order");
    }
}

