/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

@Name(value="Last Color")
@Description(value={"The colors used at the end of a string. The colors of the returned string will be formatted with their symbols."})
@Examples(value={"set {_color} to the last colors of \"<red>hey<blue>yo\""})
@Since(value="2.6")
public class ExprLastColor
extends SimplePropertyExpression<String, String> {
    @Override
    @Nullable
    public String convert(String string) {
        return ChatColor.getLastColors((String)string);
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "last colors";
    }

    static {
        ExprLastColor.register(ExprLastColor.class, String.class, "last color[s]", "strings");
    }
}

