/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.sections.SecLoop;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.converter.Converter;
import org.skriptlang.skript.lang.converter.ConverterInfo;
import org.skriptlang.skript.lang.converter.Converters;

@Name(value="Loop value")
@Description(value={"Returns the currently looped value."})
@Examples(value={"# Countdown", "loop 10 times:", "\tmessage \"%11 - loop-number%\"", "\twait a second", "", "# Generate a 10x10 floor made of randomly colored wool below the player", "loop blocks from the block below the player to the block 10 east of the block below the player:", "\tloop blocks from the loop-block to the block 10 north of the loop-block:", "\t\tset loop-block-2 to any wool", "", "loop {top-balances::*}:", "\tloop-iteration <= 10", "\tsend \"##%loop-iteration% %loop-index% has $%loop-value%\""})
@Since(value="1.0, 2.8.0 (loop-counter)")
public class ExprLoopValue
extends SimpleExpression<Object> {
    private String name;
    private SecLoop loop;
    boolean isVariableLoop = false;
    boolean isIndex = false;
    private static final Pattern LOOP_PATTERN;

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.name = parser.expr;
        String s = "" + parser.regexes.get(0).group();
        int i = -1;
        Matcher m = LOOP_PATTERN.matcher(s);
        if (m.matches()) {
            s = "" + m.group(1);
            i = Utils.parseInt("" + m.group(2));
        }
        if ("counter".equalsIgnoreCase(s) || "iteration".equalsIgnoreCase(s)) {
            return false;
        }
        Class<?> c = Classes.getClassFromUserInput(s);
        int j = 1;
        SecLoop loop = null;
        for (SecLoop l : this.getParser().getCurrentSections(SecLoop.class)) {
            if ((c == null || !c.isAssignableFrom(l.getLoopedExpression().getReturnType())) && !"value".equalsIgnoreCase(s) && !l.getLoopedExpression().isLoopOf(s)) continue;
            if (j < i) {
                ++j;
                continue;
            }
            if (loop != null) {
                Skript.error("There are multiple loops that match loop-" + s + ". Use loop-" + s + "-1/2/3/etc. to specify which loop's value you want.");
                return false;
            }
            loop = l;
            if (j != i) continue;
            break;
        }
        if (loop == null) {
            Skript.error("There's no loop that matches 'loop-" + s + "'");
            return false;
        }
        if (loop.getLoopedExpression() instanceof Variable) {
            this.isVariableLoop = true;
            if (((Variable)loop.getLoopedExpression()).isIndexLoop(s)) {
                this.isIndex = true;
            }
        }
        this.loop = loop;
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    protected <R> @Nullable ConvertedExpression<Object, ? extends R> getConvertedExpr(final Class<R> ... to) {
        if (this.isVariableLoop && !this.isIndex) {
            Class<?> superType = Utils.getSuperType(to);
            return new ConvertedExpression(this, superType, new ConverterInfo(Object.class, superType, new Converter<Object, R>(){

                @Override
                public @Nullable R convert(Object o) {
                    return Converters.convert(o, to);
                }
            }, 0));
        }
        return super.getConvertedExpr(to);
    }

    @Override
    public Class<? extends Object> getReturnType() {
        if (this.isIndex) {
            return String.class;
        }
        return this.loop.getLoopedExpression().getReturnType();
    }

    @Override
    protected @Nullable Object[] get(Event e) {
        if (this.isVariableLoop) {
            Map.Entry current = (Map.Entry)this.loop.getCurrent(e);
            if (current == null) {
                return null;
            }
            if (this.isIndex) {
                return new String[]{(String)current.getKey()};
            }
            Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
            one[0] = current.getValue();
            return one;
        }
        Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
        one[0] = this.loop.getCurrent(e);
        return one;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return this.name;
        }
        if (this.isVariableLoop) {
            Map.Entry current = (Map.Entry)this.loop.getCurrent(e);
            if (current == null) {
                return Classes.getDebugMessage(null);
            }
            return this.isIndex ? "\"" + (String)current.getKey() + "\"" : Classes.getDebugMessage(current.getValue());
        }
        return Classes.getDebugMessage(this.loop.getCurrent(e));
    }

    static {
        Skript.registerExpression(ExprLoopValue.class, Object.class, ExpressionType.SIMPLE, "[the] loop-<.+>");
        LOOP_PATTERN = Pattern.compile("^(.+)-(\\d+)$");
    }
}

