/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Loot")
@Description(value={"The loot that will be generated in a 'loot generate' event."})
@Examples(value={"on loot generate:", "\tchance of %10", "\tadd 64 diamonds", "\tsend \"You hit the jackpot!!\""})
@Since(value="2.7")
@RequiredPlugins(value={"MC 1.16+"})
public class ExprLoot
extends SimpleExpression<ItemStack> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)LootGenerateEvent.class)) {
            Skript.error("The 'loot' expression can only be used in a 'loot generate' event");
            return false;
        }
        return true;
    }

    protected @Nullable ItemStack[] get(Event event) {
        if (!(event instanceof LootGenerateEvent)) {
            return new ItemStack[0];
        }
        return ((LootGenerateEvent)event).getLoot().toArray(new ItemStack[0]);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case REMOVE: 
            case SET: 
            case DELETE: {
                return CollectionUtils.array(ItemStack[].class);
            }
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(event instanceof LootGenerateEvent)) {
            return;
        }
        LootGenerateEvent lootEvent = (LootGenerateEvent)event;
        ArrayList<ItemStack> items = null;
        if (delta != null) {
            items = new ArrayList<ItemStack>(delta.length);
            for (Object item : delta) {
                items.add((ItemStack)item);
            }
        }
        switch (mode) {
            case ADD: {
                lootEvent.getLoot().addAll(items);
                break;
            }
            case REMOVE: {
                lootEvent.getLoot().removeAll(items);
                break;
            }
            case SET: {
                lootEvent.setLoot(items);
                break;
            }
            case DELETE: {
                lootEvent.getLoot().clear();
            }
        }
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "the loot";
    }

    static {
        if (Skript.classExists("org.bukkit.event.world.LootGenerateEvent")) {
            Skript.registerExpression(ExprLoot.class, ItemStack.class, ExpressionType.SIMPLE, "[the] loot");
        }
    }
}

