/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import org.bukkit.entity.Entity;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Maximum Freeze Time")
@Description(value={"The maximum amount of time an entity can spend in powdered snow before taking damage."})
@Examples(value={"difference between player's freeze time and player's max freeze time is less than 1 second:", "\tsend \"you're about to freeze!\" to the player"})
@Since(value="2.7")
public class ExprMaxFreezeTicks
extends SimplePropertyExpression<Entity, Timespan> {
    @Override
    public @Nullable Timespan convert(Entity entity) {
        return Timespan.fromTicks(entity.getMaxFreezeTicks());
    }

    @Override
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    protected String getPropertyName() {
        return "maximum freeze time";
    }

    static {
        if (Skript.methodExists(Entity.class, "getMaxFreezeTicks", new Class[0])) {
            ExprMaxFreezeTicks.register(ExprMaxFreezeTicks.class, Timespan.class, "max[imum] freeze time", "entities");
        }
    }
}

