/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="No Damage Ticks")
@Description(value={"The number of ticks that an entity is invulnerable to damage for."})
@Examples(value={"on damage:", "\tset victim's invulnerability ticks to 20 #Victim will not take damage for the next second"})
@Since(value="2.5")
public class ExprNoDamageTicks
extends SimplePropertyExpression<LivingEntity, Long> {
    @Override
    public Long convert(LivingEntity e) {
        return e.getNoDamageTicks();
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int d = delta == null ? 0 : ((Number)delta[0]).intValue();
        block7: for (LivingEntity le : (LivingEntity[])this.getExpr().getArray(e)) {
            switch (mode) {
                case ADD: {
                    int r1 = le.getNoDamageTicks() + d;
                    if (r1 < 0) {
                        r1 = 0;
                    }
                    le.setNoDamageTicks(r1);
                    continue block7;
                }
                case SET: {
                    le.setNoDamageTicks(d);
                    continue block7;
                }
                case DELETE: 
                case RESET: {
                    le.setNoDamageTicks(0);
                    continue block7;
                }
                case REMOVE: {
                    int r2 = le.getNoDamageTicks() - d;
                    if (r2 < 0) {
                        r2 = 0;
                    }
                    le.setNoDamageTicks(r2);
                    continue block7;
                }
                case REMOVE_ALL: {
                    assert (false);
                    continue block7;
                }
            }
        }
    }

    @Override
    protected String getPropertyName() {
        return "no damage ticks";
    }

    @Override
    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    static {
        ExprNoDamageTicks.register(ExprNoDamageTicks.class, Long.class, "(invulnerability|no damage) tick[s]", "livingentities");
    }
}

