/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.apache.commons.lang.NotImplementedException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="View Distance")
@Description(value={"The view distance of a player as set by the server. Can be changed.", "NOTE: This is the view distance sent by the server to the player.", "This has nothing to do with client side view distance settings", "NOTE: This may not work on some versions (such as MC 1.14.x).", "The return value in this case will be the view distance set in system.properties."})
@Examples(value={"set view distance of player to 10", "set {_view} to view distance of player", "reset view distance of all players", "add 2 to view distance of player"})
@RequiredPlugins(value={"Paper"})
@Since(value="2.4")
public class ExprPlayerViewDistance
extends SimplePropertyExpression<Player, Integer> {
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public @Nullable Integer convert(Player player) {
        return ExprPlayerViewDistance.getViewDistance(player);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case DELETE: 
            case SET: 
            case ADD: 
            case REMOVE: 
            case RESET: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int distance = delta == null ? 0 : ((Number)delta[0]).intValue();
        block6: for (Player player : (Player[])this.getExpr().getArray(event)) {
            int oldDistance = ExprPlayerViewDistance.getViewDistance(player);
            switch (mode) {
                case DELETE: 
                case SET: {
                    ExprPlayerViewDistance.setViewDistance(player, distance);
                    continue block6;
                }
                case ADD: {
                    ExprPlayerViewDistance.setViewDistance(player, oldDistance + distance);
                    continue block6;
                }
                case REMOVE: {
                    ExprPlayerViewDistance.setViewDistance(player, oldDistance - distance);
                    continue block6;
                }
                case RESET: {
                    ExprPlayerViewDistance.setViewDistance(player, Bukkit.getViewDistance());
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block6;
                }
            }
        }
    }

    private static int getViewDistance(Player player) {
        try {
            return player.getViewDistance();
        }
        catch (NotImplementedException ignore) {
            return Bukkit.getViewDistance();
        }
    }

    private static void setViewDistance(Player player, int distance) {
        try {
            player.setViewDistance(distance);
        }
        catch (NotImplementedException ignore) {
            Skript.error("'player view distance' is not available on your server version. This is NOT a Skript bug.");
        }
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    protected String getPropertyName() {
        return "view distance";
    }

    static {
        boolean bl = $assertionsDisabled = !ExprPlayerViewDistance.class.desiredAssertionStatus();
        if (Skript.methodExists(Player.class, "getViewDistance", new Class[0])) {
            ExprPlayerViewDistance.register(ExprPlayerViewDistance.class, Integer.class, "view distance[s]", "players");
        }
    }
}

