/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Random Number")
@Description(value={"A random number or integer between two given numbers. Use 'number' if you want any number with decimal parts, or use use 'integer' if you only want whole numbers.", "Please note that the order of the numbers doesn't matter, i.e. <code>random number between 2 and 1</code> will work as well as <code>random number between 1 and 2</code>."})
@Examples(value={"set the player's health to a random number between 5 and 10", "send \"You rolled a %random integer from 1 to 6%!\" to the player"})
@Since(value="1.4")
public class ExprRandomNumber
extends SimpleExpression<Number> {
    private Expression<Number> from;
    private Expression<Number> to;
    private boolean isInteger;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.from = exprs[0];
        this.to = exprs[1];
        this.isInteger = parser.hasTag("integer");
        return true;
    }

    protected @Nullable Number[] get(Event event) {
        Number from = this.from.getSingle(event);
        Number to = this.to.getSingle(event);
        if (to == null || from == null || !Double.isFinite(from.doubleValue()) || !Double.isFinite(to.doubleValue())) {
            return new Number[0];
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        double min = Math.min(from.doubleValue(), to.doubleValue());
        double max = Math.max(from.doubleValue(), to.doubleValue());
        if (this.isInteger) {
            long inf = Math2.ceil(min);
            long sup = Math2.floor(max);
            if (max - min < 1.0 && inf - sup <= 1L) {
                if (sup == inf || min == (double)inf) {
                    return new Long[]{inf};
                }
                if (max == (double)sup) {
                    return new Long[]{sup};
                }
                return new Long[0];
            }
            return new Long[]{inf + Math2.mod(((Random)random).nextLong(), sup - inf + 1L)};
        }
        return new Double[]{min + ((Random)random).nextDouble() * (max - min)};
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.isInteger ? Long.class : Double.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "a random " + (this.isInteger ? "integer" : "number") + " between " + this.from.toString(event, debug) + " and " + this.to.toString(event, debug);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    static {
        Skript.registerExpression(ExprRandomNumber.class, Number.class, ExpressionType.COMBINED, "[a] random (:integer|number) (from|between) %number% (to|and) %number%");
    }
}

