/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Script Name")
@Description(value={"Holds the current script's name (the file name without '.sk')."})
@Examples(value={"on script load:", "\tset {running::%script%} to true", "on script unload:", "\tset {running::%script%} to false"})
@Since(value="2.0")
@Events(value={"Script Load/Unload"})
public class ExprScript
extends SimpleExpression<String> {
    private String name;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        ParserInstance parser = this.getParser();
        if (!parser.isActive()) {
            Skript.error("You can't use the script expression outside of scripts!");
            return false;
        }
        String name = parser.getCurrentScript().getConfig().getFileName();
        if (name.contains(".")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        this.name = name;
        return true;
    }

    protected String[] get(Event event) {
        return new String[]{this.name};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "the script's name";
    }

    static {
        Skript.registerExpression(ExprScript.class, String.class, ExpressionType.SIMPLE, "[the] script[['s] name]", "name of [the] script");
    }
}

