/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.Script;

@Name(value="All Scripts")
@Description(value={"Returns all of the scripts, or just the enabled or disabled ones."})
@Examples(value={"command /scripts:", "\ttrigger:", "\t\tsend \"All Scripts: %scripts%\" to player", "\t\tsend \"Loaded Scripts: %enabled scripts%\" to player", "\t\tsend \"Unloaded Scripts: %disabled scripts%\" to player"})
@Since(value="2.5")
public class ExprScripts
extends SimpleExpression<String> {
    private static final String SCRIPTS_PATH;
    private boolean includeEnabled;
    private boolean includeDisabled;
    private boolean noPaths;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.includeEnabled = matchedPattern <= 1;
        this.includeDisabled = matchedPattern != 1;
        this.noPaths = parseResult.mark == 1;
        return true;
    }

    protected String[] get(Event event) {
        ArrayList<File> scripts = new ArrayList<File>();
        if (this.includeEnabled) {
            for (Script script : ScriptLoader.getLoadedScripts()) {
                scripts.add(script.getConfig().getFile());
            }
        }
        if (this.includeDisabled) {
            scripts.addAll(ScriptLoader.getDisabledScripts());
        }
        return this.formatFiles(scripts);
    }

    private String[] formatFiles(List<File> files) {
        return (String[])files.stream().map(f -> this.noPaths ? f.getName() : f.getPath().replaceFirst(Pattern.quote(SCRIPTS_PATH), "")).toArray(String[]::new);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "scripts";
    }

    static {
        Skript.registerExpression(ExprScripts.class, String.class, ExpressionType.SIMPLE, "[all [of the]] scripts [(1:without ([subdirectory] paths|parents))]", "[all [of the]] (enabled|loaded) scripts [(1:without ([subdirectory] paths|parents))]", "[all [of the]] (disabled|unloaded) scripts [(1:without ([subdirectory] paths|parents))]");
        SCRIPTS_PATH = new File(Skript.getInstance().getDataFolder(), "scripts").getPath() + File.separator;
    }
}

