/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Time Played")
@Description(value={"The amount of time a player has played for on the server. This info is stored in the player's statistics in the main world's data folder. Changing this will also change the player's stats which can be views in the client's statistics menu.", "Using this expression on offline players on Minecraft 1.14 and below will return nothing <code>&lt;none&gt;</code>."})
@Examples(value={"set {_t} to time played of player", "if player's time played is greater than 10 minutes:", "\tgive player a diamond sword", "", "set player's time played to 0 seconds"})
@RequiredPlugins(value={"MC 1.15+ (offline players)"})
@Since(value="2.5, 2.7 (offline players)")
public class ExprTimePlayed
extends SimplePropertyExpression<OfflinePlayer, Timespan> {
    private static final boolean IS_OFFLINE_SUPPORTED = Skript.methodExists(OfflinePlayer.class, "getStatistic", Statistic.class);

    @Override
    public @Nullable Timespan convert(OfflinePlayer offlinePlayer) {
        return this.getTimePlayed(offlinePlayer);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return CollectionUtils.array(Timespan.class);
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        long ticks = ((Timespan)delta[0]).getTicks();
        for (OfflinePlayer offlinePlayer : (OfflinePlayer[])this.getExpr().getArray(event)) {
            Timespan playerTimespan;
            if (!IS_OFFLINE_SUPPORTED && !offlinePlayer.isOnline() || (playerTimespan = this.getTimePlayed(offlinePlayer)) == null) continue;
            long playerTicks = playerTimespan.getTicks();
            switch (mode) {
                case ADD: {
                    ticks = playerTicks + ticks;
                    break;
                }
                case REMOVE: {
                    ticks = playerTicks - ticks;
                }
            }
            if (IS_OFFLINE_SUPPORTED) {
                offlinePlayer.setStatistic(Statistic.PLAY_ONE_MINUTE, (int)ticks);
                continue;
            }
            if (!offlinePlayer.isOnline()) continue;
            offlinePlayer.getPlayer().setStatistic(Statistic.PLAY_ONE_MINUTE, (int)ticks);
        }
    }

    @Override
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    protected String getPropertyName() {
        return "time played";
    }

    private @Nullable Timespan getTimePlayed(OfflinePlayer offlinePlayer) {
        if (IS_OFFLINE_SUPPORTED) {
            return Timespan.fromTicks(offlinePlayer.getStatistic(Statistic.PLAY_ONE_MINUTE));
        }
        if (offlinePlayer.isOnline()) {
            return Timespan.fromTicks(offlinePlayer.getPlayer().getStatistic(Statistic.PLAY_ONE_MINUTE));
        }
        return null;
    }

    static {
        ExprTimePlayed.register(ExprTimePlayed.class, Timespan.class, "time played", "offlineplayers");
    }
}

