/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Timespan;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Time Since")
@Description(value={"The time that has passed since a date. If the given date is in the future, a value will not be returned."})
@Examples(value={"send \"%time since 5 minecraft days ago% has passed since 5 minecraft days ago!\" to player"})
@Since(value="2.5")
public class ExprTimeSince
extends SimplePropertyExpression<Date, Timespan> {
    @Override
    public @Nullable Timespan convert(Date date) {
        Date now = Date.now();
        if (date.compareTo(now) < 1) {
            return date.difference(now);
        }
        return null;
    }

    @Override
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    protected String getPropertyName() {
        return "time since";
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the time since " + this.getExpr().toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprTimeSince.class, Timespan.class, ExpressionType.PROPERTY, "[the] time since %dates%");
    }
}

