/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Unix Date")
@Description(value={"Converts given Unix timestamp to a date. The Unix timespan represents the number of seconds elapsed since 1 January 1970."})
@Examples(value={"unix date of 946684800 #1 January 2000 12:00 AM (UTC Time)"})
@Since(value="2.5")
public class ExprUnixDate
extends SimplePropertyExpression<Number, Date> {
    @Override
    public @Nullable Date convert(Number n) {
        return new Date((long)(n.doubleValue() * 1000.0));
    }

    @Override
    protected String getPropertyName() {
        return "unix date";
    }

    @Override
    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        ExprUnixDate.register(ExprUnixDate.class, Date.class, "unix date", "numbers");
    }
}

