/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.WrapperExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Value Within")
@Description(value={"Gets the value within objects. Usually used with variables to get the value they store rather than the variable itself, or with lists to get the values of a type."})
@Examples(value={"set {_entity} to a random entity out of all entities", "delete entity within {_entity} # This deletes the entity itself and not the value stored in the variable", "", "set {_list::*} to \"something\", 10, \"test\" and a zombie", "broadcast the strings within {_list::*} # \"something\", \"test\""})
@Since(value="2.7")
public class ExprValueWithin
extends WrapperExpression<Object> {
    private @Nullable ClassInfo<?> classInfo;
    private @Nullable Changer changer;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression<?> expr;
        boolean plural;
        if (exprs[0] != null) {
            UnparsedLiteral unparsedLiteral = (UnparsedLiteral)exprs[0].getSource();
            String input = unparsedLiteral.getData();
            plural = Utils.getEnglishPlural(input).getSecond();
        } else {
            plural = parseResult.hasTag("s");
        }
        if (plural == exprs[1].isSingle()) {
            if (plural) {
                Skript.error("You cannot get multiple elements of a single value");
            } else {
                Skript.error(exprs[1].toString(null, false) + " may contain more than one " + (this.classInfo == null ? "value" : this.classInfo.getName()));
            }
            return false;
        }
        this.classInfo = exprs[0] == null ? null : (ClassInfo)((Literal)exprs[0]).getSingle();
        Expression<Object> expression = expr = this.classInfo == null ? exprs[1] : exprs[1].getConvertedExpression(this.classInfo.getC());
        if (expr == null) {
            return false;
        }
        this.setExpr(expr);
        return true;
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        this.changer = Classes.getSuperClassInfo(this.getReturnType()).getChanger();
        if (this.changer == null) {
            return null;
        }
        return this.changer.acceptChange(mode);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (this.changer == null) {
            throw new UnsupportedOperationException();
        }
        this.changer.change(this.getArray(event), delta, mode);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return (this.classInfo == null ? "value" : this.classInfo.toString(event, debug)) + " within " + this.getExpr();
    }

    static {
        Skript.registerExpression(ExprValueWithin.class, Object.class, ExpressionType.COMBINED, "[the] (%-*classinfo%|value[:s]) (within|in) %~objects%");
    }
}

