/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Length")
@Description(value={"Gets or sets the length of a vector."})
@Examples(value={"send \"%standard length of vector 1, 2, 3%\"", "set {_v} to vector 1, 2, 3", "set standard length of {_v} to 2", "send \"%standard length of {_v}%\""})
@Since(value="2.2-dev28")
public class ExprVectorLength
extends SimplePropertyExpression<Vector, Number> {
    @Override
    public Number convert(Vector vector) {
        return vector.length();
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (delta != null);
        Object[] vectors = (Vector[])this.getExpr().getArray(event);
        double deltaLength = ((Number)delta[0]).doubleValue();
        switch (mode) {
            case REMOVE: {
                deltaLength = -deltaLength;
            }
            case ADD: {
                for (Object vector : vectors) {
                    if (deltaLength < 0.0 && vector.lengthSquared() < deltaLength * deltaLength) {
                        vector.zero();
                        continue;
                    }
                    double newLength = deltaLength + vector.length();
                    if (!vector.isNormalized()) {
                        vector.normalize();
                    }
                    vector.multiply(newLength);
                }
                break;
            }
            case SET: {
                for (Object vector : vectors) {
                    if (deltaLength < 0.0) {
                        vector.zero();
                        continue;
                    }
                    if (!vector.isNormalized()) {
                        vector.normalize();
                    }
                    vector.multiply(deltaLength);
                }
                break;
            }
        }
        this.getExpr().change(event, vectors, Changer.ChangeMode.SET);
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return "vector length";
    }

    static {
        ExprVectorLength.register(ExprVectorLength.class, Number.class, "(vector|standard|normal) length[s]", "vectors");
    }
}

